/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class AnnotationApiHelper {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final Map<Class<?>, TypeMirror> primitiveMirrors;

    public AnnotationApiHelper(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        HashMap<Class<Comparable<Boolean>>, PrimitiveType> tempPrimitiveMirrors = CollectionHelper.newHashMap();
        tempPrimitiveMirrors.put(Boolean.TYPE, typeUtils.getPrimitiveType(TypeKind.BOOLEAN));
        tempPrimitiveMirrors.put(Character.TYPE, typeUtils.getPrimitiveType(TypeKind.CHAR));
        tempPrimitiveMirrors.put(Byte.TYPE, typeUtils.getPrimitiveType(TypeKind.BYTE));
        tempPrimitiveMirrors.put(Short.TYPE, typeUtils.getPrimitiveType(TypeKind.SHORT));
        tempPrimitiveMirrors.put(Integer.TYPE, typeUtils.getPrimitiveType(TypeKind.INT));
        tempPrimitiveMirrors.put(Long.TYPE, typeUtils.getPrimitiveType(TypeKind.LONG));
        tempPrimitiveMirrors.put(Float.TYPE, typeUtils.getPrimitiveType(TypeKind.FLOAT));
        tempPrimitiveMirrors.put(Double.TYPE, typeUtils.getPrimitiveType(TypeKind.DOUBLE));
        this.primitiveMirrors = Collections.unmodifiableMap(tempPrimitiveMirrors);
    }

    public List<AnnotationMirror> filterByType(List<? extends AnnotationMirror> annotationMirrors, TypeMirror annotationType) {
        ArrayList<AnnotationMirror> theValue = CollectionHelper.newArrayList();
        if (annotationMirrors == null || annotationType == null) {
            return theValue;
        }
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!this.typeUtils.isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            theValue.add(annotationMirror);
        }
        return theValue;
    }

    public AnnotationMirror getMirror(List<? extends AnnotationMirror> annotationMirrors, Class<? extends Annotation> annotationClazz) {
        return this.getMirror(annotationMirrors, annotationClazz.getCanonicalName());
    }

    public AnnotationMirror getMirror(List<? extends AnnotationMirror> annotationMirrors, String annotationTypeName) {
        if (annotationMirrors == null || annotationTypeName == null) {
            return null;
        }
        TypeElement typeElement = this.elementUtils.getTypeElement(annotationTypeName);
        if (typeElement == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!this.typeUtils.isSameType(annotationMirror.getAnnotationType(), typeElement.asType())) continue;
            return annotationMirror;
        }
        return null;
    }

    public TypeMirror getMirrorForType(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.typeUtils.getArrayType(this.getMirrorForNonArrayType(clazz.getComponentType()));
        }
        return this.getMirrorForNonArrayType(clazz);
    }

    private TypeMirror getMirrorForNonArrayType(Class<?> clazz) {
        TypeMirror theValue = null;
        theValue = clazz.isPrimitive() ? this.primitiveMirrors.get(clazz) : this.getDeclaredTypeByName(clazz.getCanonicalName());
        if (theValue != null) {
            return theValue;
        }
        throw new AssertionError((Object)("Couldn't find a type mirror for class " + clazz));
    }

    public DeclaredType getDeclaredTypeByName(String className) {
        TypeElement typeElement = this.elementUtils.getTypeElement(className);
        return typeElement != null ? this.typeUtils.getDeclaredType(typeElement, new TypeMirror[0]) : null;
    }

    public AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String name) {
        if (annotationMirror == null || name == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> oneElementValue : elementValues.entrySet()) {
            if (!oneElementValue.getKey().getSimpleName().contentEquals(name)) continue;
            return oneElementValue.getValue();
        }
        return null;
    }

    public AnnotationValue getAnnotationValueOrDefault(AnnotationMirror annotationMirror, String name) {
        if (annotationMirror == null || name == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = this.elementUtils.getElementValuesWithDefaults(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> oneElementValue : elementValues.entrySet()) {
            if (!oneElementValue.getKey().getSimpleName().contentEquals(name)) continue;
            return oneElementValue.getValue();
        }
        return null;
    }

    public List<? extends AnnotationValue> getAnnotationArrayValue(AnnotationMirror annotationMirror, String name) {
        AnnotationValue annotationValue = this.getAnnotationValue(annotationMirror, name);
        if (annotationValue == null) {
            return Collections.emptyList();
        }
        List<? extends AnnotationValue> theValue = annotationValue.accept(new SimpleAnnotationValueVisitor6<List<? extends AnnotationValue>, Void>(){

            @Override
            public List<? extends AnnotationValue> visitArray(List<? extends AnnotationValue> values, Void p) {
                return values;
            }
        }, null);
        return theValue != null ? theValue : Collections.emptyList();
    }

    public Set<TypeMirror> keepLowestTypePerHierarchy(Set<TypeMirror> types) {
        if (types == null) {
            return null;
        }
        HashSet<TypeMirror> theValue = CollectionHelper.newHashSet();
        for (TypeMirror typeMirror1 : types) {
            boolean foundSubType = false;
            for (TypeMirror typeMirror2 : types) {
                if (this.typeUtils.isSameType(typeMirror2, typeMirror1) || !this.typeUtils.isAssignable(typeMirror2, typeMirror1)) continue;
                foundSubType = true;
            }
            if (foundSubType) continue;
            theValue.add(typeMirror1);
        }
        return theValue;
    }

    public boolean isInterface(TypeMirror typeMirror) {
        return TypeKind.DECLARED.equals((Object)typeMirror.getKind()) && ((DeclaredType)typeMirror).asElement().getKind().isInterface();
    }

    public boolean isClass(TypeMirror typeMirror) {
        return TypeKind.DECLARED.equals((Object)typeMirror.getKind()) && ((DeclaredType)typeMirror).asElement().getKind().isClass();
    }

    public UnwrapMode determineUnwrapMode(AnnotationMirror annotationMirror) {
        return this.getAnnotationArrayValue(annotationMirror, "payload").stream().map(AnnotationValue::getValue).map(type -> (TypeMirror)type).map(this.typeUtils::asElement).map(elem -> ((TypeElement)elem).getQualifiedName()).filter(name -> name.toString().startsWith("javax.validation.valueextraction.Unwrapping.")).map(UnwrapMode::of).findAny().orElse(UnwrapMode.NONE);
    }

    public static enum UnwrapMode {
        UNWRAP,
        SKIP,
        NONE;


        public static UnwrapMode of(Name qualifiedName) {
            if ("javax.validation.valueextraction.Unwrapping.Unwrap".equals(qualifiedName.toString())) {
                return UNWRAP;
            }
            if ("javax.validation.valueextraction.Unwrapping.Skip".equals(qualifiedName.toString())) {
                return SKIP;
            }
            return NONE;
        }
    }
}

