/*
 * Decompiled with CFR 0.152.
 */
package jwebform.validation.criteria;

import java.util.regex.Pattern;
import jwebform.validation.Criterion;
import jwebform.validation.ValidationResult;

public class Regex
implements Criterion {
    private final Pattern pattern;
    private final String stringPattern;
    private String errorMsg = "jwebform.regexp";

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    protected Regex(String pattern, boolean considerCase) {
        this.stringPattern = pattern;
        this.pattern = !considerCase ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
    }

    Regex(String pattern) {
        this(pattern, true);
    }

    public Regex ignoreCose() {
        return new Regex(this.stringPattern, false);
    }

    @Override
    public ValidationResult validate(String value) {
        boolean isValid = this.pattern.matcher(value).find();
        if (!isValid) {
            return ValidationResult.fail(this.errorMsg, new Object[0]);
        }
        return ValidationResult.ok();
    }
}

