/*
 * Decompiled with CFR 0.152.
 */
package jwebform.validation.criteria;

import jwebform.validation.Criterion;
import jwebform.validation.ValidationResult;

public final class Or
implements Criterion {
    private final Criterion[] criteria;

    Or(Criterion ... criteria) {
        if (criteria.length < 2) {
            throw new IllegalArgumentException(this.getClass().getName() + " requires at least two criteria");
        }
        this.criteria = criteria;
    }

    @Override
    public ValidationResult validate(String value) {
        ValidationResult failedResult = ValidationResult.ok();
        for (Criterion criterion : this.criteria) {
            ValidationResult vr = criterion.validate(value);
            if (vr.isValid) {
                return vr;
            }
            failedResult = vr;
        }
        return failedResult;
    }
}

