/*
 * Decompiled with CFR 0.152.
 */
package jwebform.themes.sourcecode.producer;

import java.util.List;
import jwebform.field.SelectType;
import jwebform.field.structure.HTMLProducer;
import jwebform.model.ProducerInfos;
import jwebform.themes.sourcecode.Theme;

public class SelectProducer
implements HTMLProducer {
    private final Theme theme;

    public SelectProducer(Theme theme) {
        this.theme = theme;
    }

    @Override
    public String getHTML(ProducerInfos pi) {
        SelectType type = (SelectType)pi.getType();
        return this.theme.getRenderer().renderInputComplex("select", this.buildEntries(pi.getValue(), type.entries, type.groups), pi, pi.getDecoration());
    }

    private String buildEntries(String value, List<SelectType.SelectInputEntry> entries, List<SelectType.SelectInputEntryGroup> groups) {
        StringBuilder inputTag = new StringBuilder();
        if (!groups.isEmpty()) {
            groups.forEach(group -> {
                inputTag.append("<optgroup label=\"" + group.getLabel() + "\">");
                this.buildEntries(inputTag, group.getEntries(), value);
                inputTag.append("</optgroup>");
            });
        } else {
            this.buildEntries(inputTag, entries, value);
        }
        return inputTag.toString();
    }

    private void buildEntries(StringBuilder inputTag, List<SelectType.SelectInputEntry> entries2, String inputValue) {
        entries2.forEach(entry -> {
            String sel = "";
            if (entry.getKey().equals(inputValue)) {
                sel = " SELECTED ";
            }
            inputTag.append("<option value=\"" + entry.getKey() + "\"" + sel + ">" + entry.getValue() + "</option>\n");
        });
    }
}

