/*
 * Decompiled with CFR 0.152.
 */
package jwebform.themes.sourcecode;

import com.coverity.security.Escape;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jwebform.themes.sourcecode.StringUtils;

public class TagAttributes {
    private final LinkedHashMap<String, String> attributes;

    public static TagAttributes empty() {
        return new TagAttributes();
    }

    public TagAttributes(Map<String, String> attribs) {
        this.attributes = new LinkedHashMap<String, String>(attribs);
    }

    public TagAttributes(LinkedHashMap<String, String> attribs) {
        this.attributes = attribs;
    }

    public TagAttributes() {
        this(new LinkedHashMap<String, String>());
    }

    public TagAttributes(String key, String value) {
        this();
        this.put(key, value);
    }

    public TagAttributes put(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public String get(String key) {
        return this.attributes.get(key);
    }

    public void addToAttribute(String key, String value) {
        if (!this.attributes.containsKey(key)) {
            this.attributes.put(key, value);
        } else {
            this.attributes.put(key, this.attributes.get(key) + value);
        }
    }

    public void addEmptyAttribute(String key) {
        this.attributes.put(key, "");
    }

    public Set<String> keySet() {
        return this.attributes.keySet();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void add(TagAttributes formAttributes) {
        formAttributes.attributes.forEach((key, value) -> this.addToAttribute((String)key, (String)value));
    }

    public void add(LinkedHashMap<String, String> attribs) {
        attribs.forEach((key, value) -> this.addToAttribute((String)key, (String)value));
    }

    public String renderHtml() {
        return this.buildAttributes().trim();
    }

    public String buildAttributes() {
        StringBuilder attrStr = new StringBuilder();
        this.attributes.forEach((k, v) -> attrStr.append(this.buildSingleAttribute((String)k, this.attributes.get(k))));
        return attrStr.toString();
    }

    public String buildSingleAttribute(String key, String value) {
        StringBuilder attrStr = new StringBuilder();
        if (StringUtils.isEmpty(value)) {
            attrStr.append(key);
        } else {
            String escapedValue = Escape.html(value);
            escapedValue = escapedValue.replaceAll("&#x20;", " ");
            attrStr.append(key).append("=\"").append(escapedValue).append("\"");
        }
        attrStr.append(" ");
        return attrStr.toString();
    }

    public String toString() {
        return this.renderHtml();
    }
}

