/*
 * Decompiled with CFR 0.152.
 */
package jwebform.themes.common;

import java.util.Map;
import jwebform.FormResult;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.ForceFileuploadMethod;
import jwebform.themes.sourcecode.Tag;

public class StartEndRenderer {
    public static final String SUBMIT_KEY = "WF_SUBMITTED";
    public static final String SUBMIT_VALUE_PREFIX = "WF-";
    private final String formId;
    private final String method;
    private final boolean html5Validation;
    private final boolean uploadform;

    public StartEndRenderer(FormResult result, String method, boolean html5Validation) {
        this.formId = result.getFormId();
        this.method = method;
        this.html5Validation = html5Validation;
        this.uploadform = this.determineUploadTypeAutomatically(result);
    }

    public String getStart() {
        return this.getStart("");
    }

    public String getStart(String additional) {
        String formTag = "<form name=\"" + this.formId + "-FORMCHECKER\" method=\"" + this.method + "\" id=\"" + this.formId + "\"" + this.getUpload(this.uploadform) + this.getHtml5Validaiton(this.html5Validation) + additional + ">\n";
        String submittedTag = "<input type=\"hidden\" name=\"WF_SUBMITTED\" value=\"WF-" + this.formId + "\">\n";
        return formTag + submittedTag + "\n";
    }

    private boolean determineUploadTypeAutomatically(FormResult result) {
        for (Map.Entry<Field, FieldResult> entry : result.getFieldResults()) {
            if (!(entry.getKey().fieldType instanceof ForceFileuploadMethod)) continue;
            return true;
        }
        return false;
    }

    private String getHtml5Validaiton(boolean html5Validation) {
        if (!html5Validation) {
            return " novalidate ";
        }
        return "";
    }

    private String getUpload(boolean uploadform2) {
        if (this.uploadform) {
            return " enctype=\"multipart/form-data\" ";
        }
        return "";
    }

    public String getEnd() {
        Tag startTag = new Tag("form");
        return startTag.getEndHtml();
    }
}

