/*
 * Decompiled with CFR 0.152.
 */
package jwebform.spring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import jwebform.integration.FormRenderer;
import jwebform.integration.FormRunnerConfig;
import jwebform.integration.bean2form.Bean2Form;
import jwebform.integration.bean2form.DefaultBean2Form;
import jwebform.integration.beanvalidation.BeanValidationRuleDeliverer;
import jwebform.integration.beanvalidation.BeanValidationValidator;
import jwebform.integration.beanvalidation.ExternalValidation;
import jwebform.integration.beanvalidation.ExternalValidationDescription;
import jwebform.model.FormModelBuilder;
import jwebform.spring.ContainerFormRunnerArgumentResolver;
import jwebform.spring.FormRunnerArgumentResolver;
import jwebform.spring.JWebFormProperties;
import jwebform.themes.FormModelWithFormRenderer;
import jwebform.themes.sourcecode.BootstrapTheme;
import jwebform.themes.sourcecode.ThemeJavaRenderer;
import jwebform.themes.sourcecode.mapper.StandardMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={FormRenderer.class})
@EnableConfigurationProperties(value={JWebFormProperties.class})
public class JWebFormAutoConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    public JWebFormProperties properties;
    @Autowired
    public FormRenderer formRenderer;
    @Autowired
    public Bean2Form bean2Form;
    @Autowired
    public FormModelBuilder formModelBuilder;
    @Autowired
    private MessageSource messageSource;

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolver) {
        FormRunnerConfig formRunnerConfig = new FormRunnerConfig(this.formRenderer, this.bean2Form, this.formModelBuilder, this.properties.getTemplateName());
        argumentResolver.add(new FormRunnerArgumentResolver(formRunnerConfig));
        argumentResolver.add(new ContainerFormRunnerArgumentResolver(formRunnerConfig));
    }

    @Configuration
    @ConditionalOnMissingBean(value={FormModelBuilder.class})
    public static class FormModelBuilderDefaultConfiguration {
        @Bean
        public FormModelBuilder formModelBuilder(FormRenderer formRenderer) {
            return (a, b, c) -> new FormModelWithFormRenderer(a, b, c, formRenderer);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={FormRenderer.class})
    public static class JWebFormDefaultConfiguration {
        @Bean
        public FormRenderer formRenderer(MessageSource messageSource) {
            ThemeJavaRenderer renderer = new ThemeJavaRenderer(new StandardMapper(BootstrapTheme.instance(key -> messageSource.getMessage(key, null, LocaleContextHolder.getLocale()))));
            return renderer;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={Bean2Form.class})
    @ConditionalOnClass(value={Validator.class})
    public static class JWebFormBean2FormDefaultConfig {
        @Bean
        Bean2Form bean2Form(Validator validator) {
            return new DefaultBean2Form(this.getBeanValidator(validator), this.getRuleDeliverer(validator));
        }

        private BeanValidationRuleDeliverer getRuleDeliverer(Validator validator) {
            return (bean, name) -> {
                HashSet criteraSet = new HashSet();
                BeanDescriptor i = validator.getConstraintsForClass(bean.getClass());
                PropertyDescriptor b = i.getConstraintsForProperty(name);
                if (b != null) {
                    Set<ConstraintDescriptor<?>> z = b.getConstraintDescriptors();
                    z.forEach(constraintDesc -> criteraSet.add(new ExternalValidationDescription(constraintDesc.getAnnotation().annotationType().getSimpleName(), constraintDesc.getAttributes())));
                }
                return criteraSet;
            };
        }

        private BeanValidationValidator getBeanValidator(Validator validator) {
            return b -> {
                Set<ConstraintViolation<Object>> vals = validator.validate(b, new Class[0]);
                ArrayList externalVals = new ArrayList();
                vals.forEach(constr -> {
                    ExternalValidation e = new ExternalValidation(constr.getPropertyPath().toString(), constr.getMessage());
                    externalVals.add(e);
                });
                return externalVals;
            };
        }
    }
}

