/*
 * Decompiled with CFR 0.152.
 */
package jwebform.processor;

import jwebform.FormModel;
import jwebform.FormResult;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.SingleFieldType;
import jwebform.model.FormModelBuilder;
import jwebform.processor.FieldResults;
import jwebform.processor.Logger;

public class LoggingFormResult
extends FormResult {
    public LoggingFormResult(String formId, FieldResults fieldResults, boolean formIsValid, boolean isFirstrun) {
        super(formId, fieldResults, formIsValid, isFirstrun, FormModel::new);
    }

    public LoggingFormResult(String formId, FieldResults fieldResults, boolean formIsValid, boolean isFirstrun, FormModelBuilder formModelBuilder) {
        super(formId, fieldResults, formIsValid, isFirstrun, formModelBuilder);
    }

    public void logForm(Logger logger2) {
        StringBuilder b = new StringBuilder("\n");
        this.debugOutput(this.getFieldResults(), b, "");
        logger2.log(b.toString());
    }

    private String debugOutput(FieldResults fieldResults, StringBuilder b, String indent) {
        fieldResults.forEach(entry -> {
            Field container = (Field)entry.getKey();
            FieldResult result = (FieldResult)entry.getValue();
            if (container.fieldType instanceof SingleFieldType) {
                this.appendSingleType(b, container, result, indent);
            } else {
                this.appendSingleType(b, container, result, indent);
                this.debugOutput(result.getChilds(), b, indent + "---- ");
            }
        });
        return "Form valid: " + this.isValid() + "\n " + b.toString();
    }

    private void appendSingleType(StringBuilder b, Field container, FieldResult result, String indent) {
        b.append("---------------------\n").append(indent).append("Typ    : ").append(container.fieldType.getClass().getName()).append("\n").append(indent).append("Name   : ").append(result.getStaticFieldInfo().getName()).append("\n").append(indent).append("Value  : ").append(result.getValue()).append("\n").append(indent).append("Valdid : ").append(result.getValidationResult().isValid() ? "OK" : "Not OK").append("\n");
    }
}

