/*
 * Decompiled with CFR 0.152.
 */
package jwebform.field.helper;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import jwebform.env.Env;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.StaticFieldInfo;
import jwebform.processor.FieldResults;
import jwebform.processor.FieldValdationResults;
import jwebform.validation.FormValidator;
import jwebform.validation.ValidationResult;

public class DateTypeHelper {
    private final Field day;
    private final Field month;
    private final Field year;
    private final String name;

    public DateTypeHelper(Field day, Field month, Field year, String name) {
        this.day = day;
        this.month = month;
        this.year = year;
        this.name = name;
    }

    private Optional<LocalDate> setupDateValue(String dayStr, String monthStr, String yearStr) {
        if (this.isEmpty(dayStr) && this.isEmpty(monthStr) && this.isEmpty(yearStr)) {
            return Optional.empty();
        }
        int dayInt = this.getDefaultValueFromRequest(dayStr);
        int monthInt = this.getDefaultValueFromRequest(monthStr);
        int yearInt = this.getDefaultValueFromRequest(yearStr);
        return Optional.of(LocalDate.of(yearInt, monthInt, dayInt));
    }

    private int getDefaultValueFromRequest(String input) {
        return Integer.parseInt(input);
    }

    public List<FormValidator> getValidators() {
        return Collections.singletonList(fieldResults -> {
            FieldValdationResults validationResult = new FieldValdationResults();
            FieldResult dayResult = fieldResults.get(this.day);
            FieldResult monthResult = fieldResults.get(this.month);
            FieldResult yearResult = fieldResults.get(this.year);
            try {
                this.setupDateValue(dayResult.getValue(), monthResult.getValue(), yearResult.getValue());
            }
            catch (NumberFormatException | DateTimeException runtimeException) {
                // empty catch block
            }
            return validationResult;
        });
    }

    public FieldResult processDateVal(Env.EnvWithSubmitInfo env, FieldResults childs, String fallbackTypename) {
        ValidationResult validationResult = ValidationResult.undefined();
        String dateValStr = "";
        Optional<Object> dateToSet = Optional.empty();
        if (env.isSubmitted()) {
            try {
                Optional<LocalDate> dateOptinal = this.setupDateValue(childs.get(this.day).getValue(), childs.get(this.month).getValue(), childs.get(this.year).getValue());
                dateToSet = dateOptinal;
                dateValStr = dateOptinal.isPresent() ? dateOptinal.get().format(DateTimeFormatter.ISO_DATE) : "";
                validationResult = ValidationResult.ok();
            }
            catch (NumberFormatException | DateTimeException e) {
                validationResult = ValidationResult.fail("jwebform.wrong_date_format", new Object[0]);
            }
        }
        FieldResult result = FieldResult.builder().withValue(dateValStr).withChilds(childs).withStaticFieldInfo(new StaticFieldInfo(this.name, t -> "<!-- " + fallbackTypename + " -->", 3)).withValueObject(dateToSet).build();
        if (validationResult != ValidationResult.undefined()) {
            return result.cloneWithNewValidationResult(validationResult);
        }
        return result;
    }

    private boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }
}

