/*
 * Decompiled with CFR 0.152.
 */
package jwebform.field.helper;

import java.util.ArrayList;
import java.util.List;
import jwebform.field.SelectType;

public class CommonSelects {
    private static final String[] months = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};

    private CommonSelects() {
    }

    public static CommonSelects build() {
        return new CommonSelects();
    }

    public List<SelectType.SelectInputEntry> buildDays() {
        List<SelectType.SelectInputEntry> daySelect = this.buildMap(1, 31, "jwebform.select.day");
        return daySelect;
    }

    public List<SelectType.SelectInputEntry> buildMonths() {
        ArrayList<SelectType.SelectInputEntry> monthsList = new ArrayList<SelectType.SelectInputEntry>();
        monthsList.add(new SelectType.SelectInputEntry("", "jwebform.select.month"));
        for (int i = 1; i <= 12; ++i) {
            monthsList.add(new SelectType.SelectInputEntry(Integer.toString(i), "jwebform.select." + months[i - 1]));
        }
        return monthsList;
    }

    public List<SelectType.SelectInputEntry> getYears(int startYear, int endYear) {
        if (startYear < endYear) {
            int tmp = startYear;
            startYear = endYear;
            endYear = tmp;
        }
        List<SelectType.SelectInputEntry> yearMap = this.builReverseMap(startYear, endYear, "jwebform.select.year");
        return yearMap;
    }

    public List<SelectType.SelectInputEntry> getGenderSelect() {
        ArrayList<SelectType.SelectInputEntry> genderSelect = new ArrayList<SelectType.SelectInputEntry>();
        this.addToList(genderSelect, "f", "jwebform.select.female");
        this.addToList(genderSelect, "m", "jwebform.select.male");
        return genderSelect;
    }

    private List<SelectType.SelectInputEntry> buildMap(int start, int end, String first) {
        ArrayList<SelectType.SelectInputEntry> dayMap = new ArrayList<SelectType.SelectInputEntry>();
        this.addToList(dayMap, "", first);
        for (int i = start; i <= end; ++i) {
            this.addToList(dayMap, Integer.toString(i), Integer.toString(i));
        }
        return dayMap;
    }

    private List<SelectType.SelectInputEntry> builReverseMap(int start, int end, String first) {
        ArrayList<SelectType.SelectInputEntry> entries = new ArrayList<SelectType.SelectInputEntry>();
        entries.add(new SelectType.SelectInputEntry("", first));
        for (int i = start; i >= end; --i) {
            entries.add(new SelectType.SelectInputEntry(Integer.toString(i), Integer.toString(i)));
        }
        return entries;
    }

    private void addToList(List<SelectType.SelectInputEntry> list, String key, String value) {
        list.add(new SelectType.SelectInputEntry(key, value));
    }
}

