/*
 * Decompiled with CFR 0.152.
 */
package jwebform.field;

import java.security.SecureRandom;
import java.util.Base64;
import jwebform.env.Env;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.HTMLProducer;
import jwebform.field.structure.SingleFieldType;
import jwebform.field.structure.StaticFieldInfo;
import jwebform.validation.ValidationResult;

public class XSRFProtectionType
implements SingleFieldType {
    private static final String TOKENNAME = "tokenname";
    private static final String TOKENVAL = "tokenVal";
    private final SecureRandom random = new SecureRandom();
    private final boolean staticTokenName;

    public XSRFProtectionType() {
        this(false);
    }

    public XSRFProtectionType(boolean staticTokenName) {
        this.staticTokenName = staticTokenName;
    }

    private String getRandomValue() {
        byte[] bytes = new byte[32];
        this.random.nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    @Override
    public FieldResult apply(Env.EnvWithSubmitInfo envWith) {
        Env env = envWith.getEnv();
        env.ensureSessionAvail();
        String xsrfVal = env.getParameter(TOKENVAL);
        boolean isSubmitted = env.isSubmitted(TOKENVAL);
        boolean submittedValueEqualsSessionVal = isSubmitted && xsrfVal.equals(env.getSessionAttribute(env.getParameter(TOKENNAME)));
        ValidationResult tempValidationResult = isSubmitted && !submittedValueEqualsSessionVal ? ValidationResult.fail("formchecker.xsrf_problem", new Object[0]) : ValidationResult.ok();
        String newName = "token-" + (this.staticTokenName ? "" : Double.valueOf(Math.random()));
        xsrfVal = this.staticTokenName ? "static" : this.getRandomValue();
        env.setSessionAttribute(newName, xsrfVal);
        return FieldResult.builder().withValue("").withStaticFieldInfo(new StaticFieldInfo("xsrf_protection", this.getRenderer(newName, xsrfVal), 0)).withValidationResult(tempValidationResult).build();
    }

    public HTMLProducer getRenderer(String name, String xsrfVal) {
        return producerInfos -> {
            StringBuilder tags = new StringBuilder();
            tags.append("<input type=\"hidden\" name=\"").append(TOKENNAME).append("\" value=\"").append(name).append("\">");
            tags.append("<input type=\"hidden\" name=\"").append(TOKENVAL).append("\" value=\"").append(xsrfVal).append("\">\n");
            String rendererdHtml = tags.toString();
            String problemDescription = "";
            if (!producerInfos.getValidationResult().isValid) {
                problemDescription = "XSRF Problem!<br>";
            }
            return problemDescription + rendererdHtml;
        };
    }
}

