/*
 * Decompiled with CFR 0.152.
 */
package jwebform.env;

import jwebform.env.Request;
import jwebform.env.SessionGet;
import jwebform.env.SessionSet;

public class Env {
    static final SessionGet EMPTY_SESSION_GET = t -> "";
    static final SessionSet EMPTY_SESSION_SET = (k, v) -> {};
    private static final String SUBMIT_KEY = "WF_SUBMITTED";
    private static final String SUBMIT_VALUE_PREFIX = "WF-";
    private final Request request;
    private final SessionGet sessionGet;
    private final SessionSet sessionSet;

    protected Env(Request request, SessionGet sessionGet, SessionSet sessionSet) {
        this.request = request;
        this.sessionGet = sessionGet;
        this.sessionSet = sessionSet;
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean isSubmitted(String name) {
        return this.request.isSubmitted(name);
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Object getSessionAttribute(String attributeName) {
        return this.sessionGet.getAttribute(attributeName);
    }

    public void setSessionAttribute(String name, Object o) {
        this.sessionSet.setAttribute(name, o);
    }

    public void ensureSessionAvail() {
        if (this.sessionGet == EMPTY_SESSION_GET || this.sessionSet == EMPTY_SESSION_SET) {
            throw new SessionMissingException();
        }
    }

    public EnvWithSubmitInfo getEnvWithSumitInfo(String formId) {
        return new EnvWithSubmitInfo(formId, this);
    }

    public class EnvWithSubmitInfo {
        private final Env env;
        private final boolean submitted;

        public EnvWithSubmitInfo(String formId, Env env) {
            this.env = env;
            this.submitted = (Env.SUBMIT_VALUE_PREFIX + formId).equals(env.getParameter(Env.SUBMIT_KEY));
        }

        public Env getEnv() {
            return this.env;
        }

        public boolean isSubmitted() {
            return this.submitted;
        }

        public boolean isFirstRun() {
            return !this.submitted;
        }
    }

    public class SessionMissingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        SessionMissingException() {
            super("Session data missing in Env. \nPlease provide sessionGet() and sessionSet() in Env!\n\n...This is needed for XSRF-Protection.\n\nExample: \nnew Env(requestParamName -> request.getParameter(requestParamName),\t// Request\nsessionParamName -> request.getSession().getAttribute(sessionParamName), // SessionGet\n(sessionParamName, value) -> request.getSession().setAttribute(sessionParamName, value) // SessionSet\n);");
        }
    }
}

