/*
 * Decompiled with CFR 0.152.
 */
package jwebform;

import jwebform.FormModel;
import jwebform.model.FormModelBuilder;
import jwebform.processor.FieldResults;

public class FormResult {
    private final String formId;
    private final FieldResults fieldResults;
    private final boolean formIsValid;
    private final FormModelBuilder formModelBuilder;
    private final boolean isFirstRun;

    public FormResult(String formId, FieldResults fieldResults, boolean formIsValid, boolean isFirstRun, FormModelBuilder formModelBuilder) {
        this.formId = formId;
        this.formIsValid = formIsValid;
        this.fieldResults = fieldResults;
        this.isFirstRun = isFirstRun;
        this.formModelBuilder = formModelBuilder;
    }

    public FormResult(String formId, FieldResults fieldResults, boolean formIsValid, boolean isFirstRun) {
        this.formId = formId;
        this.formIsValid = formIsValid;
        this.fieldResults = fieldResults;
        this.isFirstRun = isFirstRun;
        this.formModelBuilder = FormModel::new;
    }

    public String toString() {
        return String.format("Formid: %s, Valid: %b, Field-Results: %s", this.formId, this.formIsValid, this.fieldResults);
    }

    public final boolean isValid() {
        return this.formIsValid;
    }

    @Deprecated
    public final boolean isOK() {
        return this.formIsValid;
    }

    public final boolean isSubmitted() {
        return !this.isFirstRun;
    }

    public FormModel getFormModel(FormModel.Html5Validation html5Validation) {
        return this.formModelBuilder.build(this, FormModel.Method.POST, html5Validation);
    }

    public FormModel getFormModel(FormModel.Html5Validation html5Validation, FormModel.Method method) {
        return this.formModelBuilder.build(this, method, html5Validation);
    }

    public FormModel getFormModel(FormModel.Method method) {
        return this.formModelBuilder.build(this, method, FormModel.Html5Validation.ON);
    }

    public FormModel getFormModel() {
        return this.formModelBuilder.build(this, FormModel.Method.POST, FormModel.Html5Validation.ON);
    }

    public final FieldResults getFieldResults() {
        return this.fieldResults;
    }

    public final String getStringValue(String name) {
        return this.fieldResults.getFieldStringValue(name);
    }

    public final Object getObectValue(String name) {
        return this.fieldResults.getObectValue(name);
    }

    public String getFormId() {
        return this.formId;
    }
}

