/*
 * Decompiled with CFR 0.152.
 */
package jwebform.integration.bean2form;

import java.lang.reflect.Field;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import jwebform.Form;
import jwebform.FormBuilder;
import jwebform.field.CheckBoxType;
import jwebform.field.HiddenType;
import jwebform.field.HtmlType;
import jwebform.field.LabelType;
import jwebform.field.NumberType;
import jwebform.field.PasswordType;
import jwebform.field.RadioType;
import jwebform.field.SelectDateType;
import jwebform.field.SelectType;
import jwebform.field.SubmitType;
import jwebform.field.TextAreaType;
import jwebform.field.TextDateType;
import jwebform.field.TextType;
import jwebform.field.structure.Decoration;
import jwebform.field.structure.FieldType;
import jwebform.integration.bean2form.Bean2Form;
import jwebform.integration.bean2form.FillBeanWithFieldResults;
import jwebform.integration.bean2form.JWebFormBean;
import jwebform.integration.bean2form.annotations.IgnoreField;
import jwebform.integration.bean2form.annotations.IsRequired;
import jwebform.integration.bean2form.annotations.UseDecoration;
import jwebform.integration.bean2form.annotations.UseFieldType;
import jwebform.integration.beanvalidation.BeanValidationRuleDeliverer;
import jwebform.integration.beanvalidation.BeanValidationValidator;
import jwebform.integration.beanvalidation.ExternalValidation;
import jwebform.integration.beanvalidation.ExternalValidationDescription;
import jwebform.processor.FieldValdationResults;
import jwebform.validation.Criterion;
import jwebform.validation.FormValidator;
import jwebform.validation.ValidationResult;
import jwebform.validation.criteria.Criteria;

public class DefaultBean2Form
implements Bean2Form {
    static final LinkedHashMap<Class, BiFunction<String, Object, FieldType>> preBuildfieldCreators = DefaultBean2Form.fillFieldCreators();
    final LinkedHashMap<Class, BiFunction<String, Object, FieldType>> fieldCreators;
    final BeanValidationValidator beanValidator;
    final BeanValidationRuleDeliverer beanValidationRuleDeliverer;

    public DefaultBean2Form() {
        this(b -> new ArrayList(), (bean, name) -> Collections.emptySet(), new LinkedHashMap<Class, BiFunction<String, Object, FieldType>>());
    }

    public DefaultBean2Form(BeanValidationValidator beanValidator, BeanValidationRuleDeliverer ruleDeliverer) {
        this(beanValidator, ruleDeliverer, new LinkedHashMap<Class, BiFunction<String, Object, FieldType>>());
    }

    public DefaultBean2Form(BeanValidationValidator beanValidator, BeanValidationRuleDeliverer ruleDeliverer, LinkedHashMap<Class, BiFunction<String, Object, FieldType>> additionalFieldCreators) {
        this.beanValidator = beanValidator;
        this.beanValidationRuleDeliverer = ruleDeliverer;
        this.fieldCreators = additionalFieldCreators;
        this.fieldCreators.putAll(preBuildfieldCreators);
    }

    @Override
    public Form getFormFromBean(Object bean) {
        Field[] fieldsOfBean = bean.getClass().getFields();
        ArrayList<jwebform.field.structure.Field> fields = new ArrayList<jwebform.field.structure.Field>();
        for (Field fieldOfBean : fieldsOfBean) {
            if (this.isIgnore(fieldOfBean)) continue;
            String name = fieldOfBean.getName();
            Object initialValue = null;
            try {
                initialValue = fieldOfBean.get(bean);
                if (initialValue == null) {
                    initialValue = "";
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            Class<?> classOfField = fieldOfBean.getType();
            Decoration decoration = this.getDecoration(fieldOfBean, name);
            Optional<FieldType> oFieldType = this.checkAnnoation(fieldOfBean, name, initialValue);
            Criterion[] criteras = this.getCriterias(bean, name, fieldOfBean);
            if (oFieldType.isPresent()) {
                fields.add(new jwebform.field.structure.Field(oFieldType.get(), decoration, criteras));
                continue;
            }
            if (this.fieldCreators.containsKey(classOfField)) {
                fields.add(new jwebform.field.structure.Field(this.fieldCreators.get(classOfField).apply(name, initialValue), decoration, criteras));
                continue;
            }
            System.err.println("Unsupported value:" + String.valueOf(classOfField));
        }
        Form f = FormBuilder.withId((String)"id").fields(fields).validation(new FormValidator[]{this.generateFormValidator(bean)}).build();
        if (bean instanceof JWebFormBean) {
            Form processedByBean = ((JWebFormBean)bean).preRun(f);
            return processedByBean;
        }
        return f;
    }

    private Criterion[] getCriterias(Object bean, String name, Field fieldOfBean) {
        Set<ExternalValidationDescription> annotations;
        ArrayList<Criterion> criterionList = new ArrayList<Criterion>();
        if (fieldOfBean.isAnnotationPresent(IsRequired.class)) {
            criterionList.add(Criteria.required());
        }
        if (!(annotations = this.beanValidationRuleDeliverer.getCriteriaForField(bean, name)).isEmpty()) {
            for (ExternalValidationDescription a : annotations) {
                if (a.name.contains("NotEmpty")) {
                    criterionList.add(Criteria.required());
                    continue;
                }
                if (!a.name.contains("Size")) continue;
                criterionList.add(Criteria.maxLength((int)((Integer)a.parameters.get("max"))));
            }
        }
        return criterionList.toArray(new Criterion[criterionList.size()]);
    }

    private FormValidator generateFormValidator(Object bean) {
        return fieldResults -> {
            FillBeanWithFieldResults fillBeanWithFieldResults = new FillBeanWithFieldResults();
            fillBeanWithFieldResults.fill(bean, fieldResults);
            List<ExternalValidation> validationResults = this.beanValidator.getValidationResults(bean);
            if (bean instanceof JWebFormBean) {
                List<ExternalValidation> validationResultsFromInterface = ((JWebFormBean)bean).validate();
                validationResults.addAll(validationResultsFromInterface);
            }
            FieldValdationResults fieldValdationResults = new FieldValdationResults();
            validationResults.forEach(externalValidation -> {
                jwebform.field.structure.Field f = fieldResults.getField(externalValidation.fieldName);
                fieldValdationResults.put(f, ValidationResult.failWithTranslated((String)externalValidation.validationMessage));
            });
            return fieldValdationResults;
        };
    }

    private static LinkedHashMap<Class, BiFunction<String, Object, FieldType>> fillFieldCreators() {
        LinkedHashMap<Class, BiFunction<String, Object, FieldType>> prebuildFieldCreators = new LinkedHashMap<Class, BiFunction<String, Object, FieldType>>();
        BiFunction<String, Object, FieldType> bool2checkbox = (s, o) -> new CheckBoxType(s, DefaultBean2Form.getVal(o, Boolean.class).booleanValue());
        BiFunction<String, Object, FieldType> int2Number = (s, o) -> new NumberType(s, DefaultBean2Form.getVal(o, Integer.class).intValue());
        prebuildFieldCreators.put(CheckBoxType.class, (s, o) -> new CheckBoxType(s, DefaultBean2Form.getVal(o, Boolean.class).booleanValue()));
        prebuildFieldCreators.put(HiddenType.class, (s, o) -> new HiddenType(s, DefaultBean2Form.getVal(o, String.class)));
        prebuildFieldCreators.put(HtmlType.class, (s, o) -> new HtmlType(DefaultBean2Form.getVal(o, String.class)));
        prebuildFieldCreators.put(LabelType.class, (s, o) -> new LabelType(DefaultBean2Form.getVal(o, String.class)));
        prebuildFieldCreators.put(NumberType.class, (s, o) -> new NumberType(s, DefaultBean2Form.getVal(o, Integer.class).intValue()));
        prebuildFieldCreators.put(PasswordType.class, (s, o) -> new PasswordType(s));
        prebuildFieldCreators.put(RadioType.class, (s, o) -> new RadioType(s, DefaultBean2Form.getVal(o, String.class), DefaultBean2Form.getKeys(o), DefaultBean2Form.getVals(o)));
        prebuildFieldCreators.put(SelectDateType.class, (s, o) -> new SelectDateType(s, DefaultBean2Form.getVal(o, LocalDate.class), LocalDate.now().getYear() - 100, LocalDate.now().getYear() + 1));
        prebuildFieldCreators.put(SelectType.class, (s, o) -> new SelectType(s, DefaultBean2Form.getVal(o, String.class), DefaultBean2Form.getKeys(o), DefaultBean2Form.getVals(o)));
        prebuildFieldCreators.put(TextAreaType.class, (s, o) -> new TextAreaType(s, DefaultBean2Form.getVal(o, String.class)));
        prebuildFieldCreators.put(SubmitType.class, (s, o) -> new SubmitType(s));
        prebuildFieldCreators.put(TextDateType.class, (s, o) -> new TextDateType(s, DefaultBean2Form.getVal(o, LocalDate.class)));
        prebuildFieldCreators.put(TextType.class, (s, o) -> new TextType(s, DefaultBean2Form.getVal(o, String.class)));
        prebuildFieldCreators.put(String.class, (s, o) -> new TextType(s, DefaultBean2Form.getVal(o, String.class)));
        prebuildFieldCreators.put(Integer.class, int2Number);
        prebuildFieldCreators.put(Integer.TYPE, int2Number);
        prebuildFieldCreators.put(Boolean.class, bool2checkbox);
        prebuildFieldCreators.put(Boolean.TYPE, bool2checkbox);
        prebuildFieldCreators.put(LocalDate.class, (s, o) -> new TextDateType(s, DefaultBean2Form.getVal(o, LocalDate.class)));
        return prebuildFieldCreators;
    }

    private static <T> T getVal(Object o, Class<T> clss) {
        try {
            if (o instanceof ValuesOfObject) {
                ValuesOfObject valuesOfObject = (ValuesOfObject)o;
                return clss.cast(valuesOfObject.initialValue);
            }
            return clss.cast(o);
        }
        catch (Exception e) {
            throw new RuntimeException("I can not cast this!", e);
        }
    }

    private static String[] getVals(Object o) {
        if (o instanceof ValuesOfObject) {
            ValuesOfObject valuesOfObject = (ValuesOfObject)o;
            return valuesOfObject.useFieldTypeAnnotation.vals();
        }
        throw new IllegalArgumentException("Please call the getKeys just with a ValuesOfObject field. You called with: " + String.valueOf(o.getClass()));
    }

    private static String[] getKeys(Object o) {
        if (o instanceof ValuesOfObject) {
            ValuesOfObject valuesOfObject = (ValuesOfObject)o;
            return valuesOfObject.useFieldTypeAnnotation.keys();
        }
        throw new IllegalArgumentException("Please call the getKeys just with a ValuesOfObject field. You called with: " + String.valueOf(o.getClass()));
    }

    private boolean isIgnore(Field fieldOfBean) {
        return fieldOfBean.isAnnotationPresent(IgnoreField.class);
    }

    private Decoration getDecoration(Field fieldOfBean, String name) {
        UseDecoration decoration = fieldOfBean.getAnnotation(UseDecoration.class);
        if (decoration != null) {
            return new Decoration(decoration.label(), decoration.helpText(), decoration.placeholder(), decoration.isTranslated());
        }
        return new Decoration(name);
    }

    private Optional<FieldType> checkAnnoation(Field fieldOfBean, String name, Object initialValue) {
        UseFieldType useFieldType = fieldOfBean.getAnnotation(UseFieldType.class);
        if (useFieldType != null && this.fieldCreators.containsKey(useFieldType.value())) {
            ValuesOfObject valuesOfObject = new ValuesOfObject();
            valuesOfObject.initialValue = initialValue;
            valuesOfObject.useFieldTypeAnnotation = useFieldType;
            return Optional.of(this.fieldCreators.get(useFieldType.value()).apply(name, valuesOfObject));
        }
        return Optional.empty();
    }

    private class ValuesOfObject {
        Object initialValue;
        UseFieldType useFieldTypeAnnotation;

        private ValuesOfObject() {
        }
    }
}

