/*
 * Decompiled with CFR 0.152.
 */
package jwebform.integration;

import jwebform.validation.ValidationResult;

@FunctionalInterface
public interface MessageSource {
    public String getMessage(String var1);

    default public String getSafeMessage(String key) {
        try {
            String msg = this.getMessage(key);
            return msg;
        }
        catch (Exception e) {
            return "??" + key + "??";
        }
    }

    default public String getMessage(ValidationResult vr) {
        if (vr.getTranslatedMessage() != null) {
            return vr.getTranslatedMessage();
        }
        if (vr.getMessageKey() != null) {
            return String.format(this.getSafeMessage(vr.getMessageKey()), vr.getErrorVals());
        }
        throw new IllegalArgumentException("ValidationResult has neither message-key nor translated text");
    }
}

