/*
 * Decompiled with CFR 0.152.
 */
package jwebform.processor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import jwebform.env.Env;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.GroupFieldType;
import jwebform.field.structure.SingleFieldType;
import jwebform.processor.CheckDoubleFieldsPostProcessor;
import jwebform.processor.FieldResults;
import jwebform.processor.FieldValdationResults;
import jwebform.processor.PostProcessor;
import jwebform.validation.FormValidator;
import jwebform.validation.ValidationResult;
import jwebform.validation.Validator;

public class Processor {
    public final FieldResults run(Env.EnvWithSubmitInfo envWithSubmitInfo, GroupFieldType group) {
        FieldResults fieldResults = this.processFields(envWithSubmitInfo, group.getChilds());
        fieldResults = this.runPostProcessors(fieldResults);
        if (envWithSubmitInfo.isSubmitted()) {
            FieldValdationResults overridenValidationResults = this.runFormValidations(fieldResults, group.getValidators(group.of()));
            return this.correctFieldResults(fieldResults, overridenValidationResults);
        }
        return fieldResults;
    }

    private List<PostProcessor> getPostProcessors() {
        return Collections.singletonList(new CheckDoubleFieldsPostProcessor());
    }

    private FieldResults runPostProcessors(FieldResults fieldResults) {
        for (PostProcessor postProcessor : this.getPostProcessors()) {
            fieldResults = postProcessor.postProcess(fieldResults);
        }
        return fieldResults;
    }

    private FieldResults processFields(Env.EnvWithSubmitInfo env, List<Field> fields) {
        FieldResults fieldResults = new FieldResults();
        for (Field container : fields) {
            if (container.fieldType instanceof GroupFieldType) {
                this.processGroup(env, fieldResults, container);
                continue;
            }
            this.processSingleType(env, fieldResults, container);
        }
        return fieldResults;
    }

    private void processSingleType(Env.EnvWithSubmitInfo env, FieldResults fieldResults, Field field) {
        FieldResult result = ((SingleFieldType)field.fieldType).apply(env);
        if (env.isSubmitted() && result.getValidationResult() == ValidationResult.undefined()) {
            result = result.ofValidationResult(new Validator(field.criteria).validate(result.getValue()));
        }
        if (fieldResults.containsField(field)) {
            throw new IdenticalFieldException(field);
        }
        fieldResults.put(field, result);
    }

    private void processGroup(Env.EnvWithSubmitInfo env, FieldResults fieldResults, Field field) {
        FieldResults groupTypeResults = this.run(env, (GroupFieldType)field.fieldType);
        FieldResult groupResult = ((GroupFieldType)field.fieldType).process(env, groupTypeResults);
        if (groupResult.getValidationResult().isValid) {
            groupResult = groupResult.ofValidationResult(new Validator(field.criteria).validate(groupResult.getValue()));
        }
        fieldResults.put(field, groupResult.cloneWithChilds(groupTypeResults));
    }

    private FieldValdationResults runFormValidations(FieldResults fieldResults, List<FormValidator> formValidators) {
        FieldValdationResults overridenValidationResults = new FieldValdationResults();
        for (FormValidator formValidator : formValidators) {
            overridenValidationResults.merge(formValidator.validate(fieldResults));
        }
        return overridenValidationResults;
    }

    public boolean checkAllValidationResults(FieldResults correctedFieldResults) {
        boolean formIsValid = true;
        for (Map.Entry<Field, FieldResult> entry : correctedFieldResults) {
            if (entry.getValue().getValidationResult() == ValidationResult.ok()) continue;
            formIsValid = false;
            break;
        }
        return formIsValid;
    }

    private FieldResults correctFieldResults(FieldResults fieldResults, FieldValdationResults overridenValidationResults) {
        overridenValidationResults.getResutls().forEach((field, overridenValidationResult) -> {
            FieldResult re = fieldResults.get((Field)field);
            fieldResults.put((Field)field, re.cloneWithNewValidationResult((ValidationResult)overridenValidationResult));
        });
        return fieldResults;
    }

    public class IdenticalFieldException
    extends RuntimeException {
        public IdenticalFieldException(Field field) {
            super("Field with the same name are not allowed. Plese remove double container: " + field.fieldType);
        }
    }
}

