/*
 * Decompiled with CFR 0.152.
 */
package jwebform.processor;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jwebform.field.structure.Field;
import jwebform.field.structure.FieldResult;
import jwebform.processor.FieldValdationResults;
import jwebform.validation.ValidationResult;

public class FieldResults
implements Iterable<Map.Entry<Field, FieldResult>> {
    private final Map<Field, FieldResult> fieldResultMap;

    public FieldResults(Map<Field, FieldResult> fieldResultMap) {
        this.fieldResultMap = fieldResultMap;
    }

    public FieldResults() {
        this.fieldResultMap = new LinkedHashMap<Field, FieldResult>();
    }

    public String toString() {
        return this.fieldResultMap.toString();
    }

    public void put(Field container, FieldResult result) {
        this.fieldResultMap.put(container, result);
    }

    public boolean containsField(Field container) {
        return this.fieldResultMap.containsKey(container);
    }

    public FieldResult get(Field field) {
        return this.fieldResultMap.get(field);
    }

    @Override
    public Iterator<Map.Entry<Field, FieldResult>> iterator() {
        return this.fieldResultMap.entrySet().iterator();
    }

    public String getFieldStringValue(String fieldName) {
        for (FieldResult i : this.fieldResultMap.values()) {
            if (!fieldName.equals(i.getStaticFieldInfo().getName())) continue;
            return i.getValue();
        }
        throw new IllegalArgumentException(String.format("The field named '%s' does not exist in form", fieldName));
    }

    @Deprecated
    public final Object getObectValue(String fieldName) {
        return this.getObectValue(fieldName);
    }

    public final Object getObjectValue(String fieldName) {
        for (FieldResult i : this.fieldResultMap.values()) {
            if (!fieldName.equals(i.getStaticFieldInfo().getName())) continue;
            return i.getValueObject();
        }
        throw new FieldNotFoundException("This fieldType does not exist in form", fieldName);
    }

    public final FieldValdationResults computeSingleFieldValidation(String fieldName, ValidationResult vr) {
        return FieldValdationResults.of(this.getField(fieldName), vr);
    }

    public Field getField(String fieldName) {
        for (Map.Entry<Field, FieldResult> entry : this.fieldResultMap.entrySet()) {
            if (!fieldName.equals(entry.getValue().getStaticFieldInfo().getName())) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("The name \"" + fieldName + "\" is not within the form!");
    }

    public Object size() {
        return this.fieldResultMap.size();
    }

    public Set<Field> getContainers() {
        return this.fieldResultMap.keySet();
    }

    public class FieldNotFoundException
    extends RuntimeException {
        private final String fieldName;

        public FieldNotFoundException(String msg, String fieldName) {
            super(msg);
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

