/*
 * Decompiled with CFR 0.152.
 */
package jwebform.integration;

import java.util.function.BiConsumer;
import jwebform.FormResult;
import jwebform.env.Env;
import jwebform.env.EnvBuilder;
import jwebform.env.Request;
import jwebform.env.SessionGet;
import jwebform.env.SessionSet;
import jwebform.integration.FormResultAndBean;
import jwebform.integration.FormRunnerConfig;
import jwebform.integration.InternalFormRunner;
import jwebform.processor.FormGenerator;

public class FormRunner {
    private final Env env;
    private final BiConsumer<String, Object> model;
    private final FormRunnerConfig formRunnerConfig;
    private final InternalFormRunner internalFormRunner = new InternalFormRunner();

    public FormRunner(Request request, SessionGet sessionGet, SessionSet sessionSet, BiConsumer<String, Object> model, FormRunnerConfig formRunnerConfig) {
        this.env = new EnvBuilder().of(request, sessionGet, sessionSet);
        this.model = model;
        this.formRunnerConfig = formRunnerConfig;
    }

    public FormResultAndBean runWithBean(Object bean) {
        FormResult fr = this.internalFormRunner.runWithBean(bean, this.env, this.model, this.formRunnerConfig);
        return new FormResultAndBean(fr, bean);
    }

    public FormResult runWitFormGenerator(FormGenerator formGenerator) {
        return this.internalFormRunner.runWithBFormGenerator(formGenerator, this.env, this.model, this.formRunnerConfig);
    }

    @Deprecated
    public FormResult run(Object formOrBean) {
        return this.internalFormRunner.run(formOrBean, this.env, this.model, this.formRunnerConfig);
    }
}

