/*
 * Decompiled with CFR 0.152.
 */
package jwebform.field;

import java.util.ArrayList;
import java.util.List;
import jwebform.env.Env;
import jwebform.field.helper.OneValueTypeProcessor;
import jwebform.field.structure.FieldResult;
import jwebform.field.structure.SingleFieldType;

public class SelectType
implements SingleFieldType {
    public final List<SelectInputEntry> entries;
    public final OneValueTypeProcessor oneValueType;
    public final List<SelectInputEntryGroup> groups;
    private static final List<SelectInputEntryGroup> EMPTY_GROUPS = new ArrayList<SelectInputEntryGroup>();

    public SelectType(String name, String initialValue, String[] keys, String[] values) {
        this.oneValueType = new OneValueTypeProcessor(name, initialValue);
        this.entries = this.generateEntriesFromKeyValues(keys, values);
        this.groups = EMPTY_GROUPS;
    }

    public SelectType(String name, String initialValue, List<SelectInputEntry> entries) {
        this.oneValueType = new OneValueTypeProcessor(name, initialValue);
        this.entries = entries;
        this.groups = EMPTY_GROUPS;
    }

    public SelectType(String name, List<SelectInputEntryGroup> groups, String initialValue) {
        this.oneValueType = new OneValueTypeProcessor(name, initialValue);
        this.entries = new ArrayList<SelectInputEntry>();
        this.groups = groups;
    }

    @Override
    public FieldResult apply(Env.EnvWithSubmitInfo env) {
        return this.oneValueType.calculateTypeWithInputCheck(env, t -> "<!-- select -->", this::ensureValueIsAllowed);
    }

    private boolean ensureValueIsAllowed(String fetchValue) {
        if (!this.groups.isEmpty()) {
            for (SelectInputEntryGroup group : this.groups) {
                if (!this.checkEntries(group.entries, fetchValue)) continue;
                return true;
            }
            return false;
        }
        return this.checkEntries(this.entries, fetchValue);
    }

    private boolean checkEntries(List<SelectInputEntry> entries2, String fetchValue) {
        for (SelectInputEntry selectInputEntry : entries2) {
            if (!selectInputEntry.getKey().equals(fetchValue)) continue;
            return true;
        }
        return false;
    }

    private List<SelectInputEntry> generateEntriesFromKeyValues(String[] keys, String[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Key / Values with unequal length");
        }
        ArrayList<SelectInputEntry> entriesToCreate = new ArrayList<SelectInputEntry>();
        for (int i = 0; i < keys.length; ++i) {
            entriesToCreate.add(this.generateEntry(keys[i], values[i]));
        }
        return entriesToCreate;
    }

    public SelectInputEntry generateEntry(String key, String value) {
        return new SelectInputEntry(key, value);
    }

    public String toString() {
        return String.format("SelectInput. name=%s", this.oneValueType.name);
    }

    public List<SelectInputEntry> getSelectListWithSelected(String selectedKey) {
        ArrayList<SelectInputEntry> resultList = new ArrayList<SelectInputEntry>();
        this.entries.forEach(entry -> {
            if (entry.getKey().equals(selectedKey)) {
                resultList.add(new SelectInputEntry(((SelectInputEntry)entry).key, ((SelectInputEntry)entry).value, true));
            } else {
                resultList.add((SelectInputEntry)entry);
            }
        });
        return resultList;
    }

    public static class SelectInputEntryGroup {
        private final String label;
        List<SelectInputEntry> entries;

        public SelectInputEntryGroup(String label, List<SelectInputEntry> entries) {
            this.label = label;
            this.entries = entries;
        }

        public SelectInputEntryGroup(String label) {
            this(label, new ArrayList<SelectInputEntry>());
        }

        public void addSelectInputEntry(SelectInputEntry entry) {
            this.entries.add(entry);
        }

        public String getLabel() {
            return this.label;
        }

        public List<SelectInputEntry> getEntries() {
            return this.entries;
        }
    }

    public static class SelectInputEntry {
        private final String key;
        private final String value;
        private final boolean selcted;

        public SelectInputEntry(String key, String value) {
            this(key, value, false);
        }

        public SelectInputEntry(String key, String value, boolean selected) {
            this.key = key;
            this.value = value;
            this.selcted = selected;
        }

        public boolean isSelcted() {
            return this.selcted;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("Key: %s Value: %s Selected: %s", this.key, this.value, this.selcted);
        }
    }
}

