/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.message;

import de.jformchecker.criteria.ValidationResult;

@FunctionalInterface
public interface MessageSource {
    public String getMessage(String var1);

    default public String getSafeMessage(String key) {
        try {
            String msg = this.getMessage(key);
            return msg;
        }
        catch (Exception e) {
            return "??" + key + "??";
        }
    }

    default public String getMessage(ValidationResult vr) {
        if (vr.getTranslatedMessage() != null) {
            return vr.getTranslatedMessage();
        }
        if (vr.getMessage() != null) {
            return String.format(this.getSafeMessage(vr.getMessage()), vr.getErrorVals());
        }
        throw new IllegalArgumentException("ValidationResult has neither message-key nor translated text");
    }
}

