/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import com.coverity.security.Escape;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.StringUtils;
import de.jformchecker.TagAttributes;
import de.jformchecker.elements.AbstractInput;
import java.util.Map;

public class TextInput
extends AbstractInput<TextInput>
implements FormCheckerElement {
    private String placeholderText = "";

    public static TextInput build(String name) {
        TextInput i = new TextInput();
        i.name = name;
        return i;
    }

    public TextInput setPlaceholerText(String placeholderText) {
        this.placeholderText = placeholderText;
        return this;
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        TagAttributes tagAttributes = new TagAttributes(attributes);
        tagAttributes.add(this.inputAttributes);
        return String.format("<input " + this.buildAllAttributes(tagAttributes) + this.buildMaxLen() + "type=\"text\" name=\"%s\" value=\"%s\"" + this.getPlaceholder() + ">", this.name, this.value == null ? "" : this.getValueHtmlEncoded());
    }

    protected String getPlaceholder() {
        return StringUtils.isEmpty(this.placeholderText) ? "" : " placeholder=\"" + Escape.htmlText((String)this.placeholderText) + "\"";
    }

    @Override
    public String getType() {
        return "text";
    }
}

