/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import de.jformchecker.AttributeUtils;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.TagAttributes;
import de.jformchecker.elements.AbstractInput;
import java.util.LinkedHashMap;
import java.util.Map;

public class RadioInput
extends AbstractInput<RadioInput>
implements FormCheckerElement {
    LinkedHashMap<String, String> possibleNames = new LinkedHashMap();

    public static RadioInput build(String name) {
        RadioInput i = new RadioInput();
        i.name = name;
        return i;
    }

    public static RadioInput build(String name, LinkedHashMap<String, String> possibleNames) {
        RadioInput si = RadioInput.build(name);
        si.setPossibleValues(possibleNames);
        return si;
    }

    public static RadioInput build(String name, String[] keys, String[] values) {
        RadioInput si = RadioInput.build(name);
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Key / Values with unequal lenght");
        }
        LinkedHashMap<String, String> possibleNames = new LinkedHashMap<String, String>();
        for (int i = 0; i < keys.length; ++i) {
            possibleNames.put(keys[i], values[i]);
        }
        si.setPossibleValues(possibleNames);
        return si;
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        TagAttributes tagAttributes = new TagAttributes(attributes);
        tagAttributes.add(this.inputAttributes);
        StringBuilder inputTag = new StringBuilder();
        this.possibleNames.forEach((key, value) -> {
            if (!"".equals(value)) {
                inputTag.append(this.getInputTag((String)key, tagAttributes.getAttributes()) + " <label for=\"form-radio-" + this.name + "-" + key + "\" class=\"" + "" + "\" id=\"label-" + this.name + "-" + key + "\">" + value + " </label>\n");
            }
        });
        return inputTag.toString();
    }

    public String getInputTag(String curValue, Map<String, String> attributes) {
        return "<input id=\"form-radio-" + this.name + "-" + curValue + "\" " + AttributeUtils.buildAttributes(attributes) + this.getTabIndexTag() + " type=\"radio\" name=\"" + this.name + "\"  value=\"" + curValue + "\" " + this.getCheckedStatus(curValue) + "" + " " + " >\n";
    }

    private String getCheckedStatus(String _name) {
        if (this.value != null && this.value.equals(_name)) {
            return "checked";
        }
        return "";
    }

    @Override
    public int getLastTabIndex() {
        return this.getTabIndex();
    }

    public RadioInput setPossibleValues(LinkedHashMap<String, String> possibleNames) {
        this.possibleNames = possibleNames;
        return this;
    }

    @Override
    public void setValue(String value) {
        if (this.possibleNames.containsKey(value)) {
            this.value = value;
        }
    }

    @Override
    public String getType() {
        return "radio";
    }
}

