/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import com.coverity.security.Escape;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.StringUtils;
import de.jformchecker.TagAttributes;
import de.jformchecker.criteria.Criteria;
import de.jformchecker.elements.AbstractInput;
import java.util.Map;

public class NumberInput
extends AbstractInput<NumberInput>
implements FormCheckerElement {
    private String placeholderText = "";

    public static NumberInput build(String name) {
        NumberInput i = new NumberInput();
        i.addCriteria(Criteria.number());
        i.name = name;
        return i;
    }

    public NumberInput setPlaceholerText(String placeholderText) {
        this.placeholderText = placeholderText;
        return this;
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        TagAttributes tagAttributes = new TagAttributes(attributes);
        tagAttributes.add(this.inputAttributes);
        return String.format("<input " + this.buildAllAttributes(tagAttributes) + this.buildMaxLen() + "type=\"number\" name=\"%s\" value=\"%s\"" + this.getPlaceholder() + ">", this.name, this.value == null ? "" : this.getValueHtmlEncoded());
    }

    private String getPlaceholder() {
        return StringUtils.isEmpty(this.placeholderText) ? "" : " placeholder=\"" + Escape.htmlText((String)this.placeholderText) + "\"";
    }

    public void setValue(int value) {
        this.setValue(Integer.toString(value));
    }

    public int getIntValue() {
        return Integer.parseInt(this.getValue());
    }

    public FormCheckerElement presetIntValue(int intVal) {
        this.setPreSetValue(Integer.toString(intVal));
        return this;
    }

    @Override
    public String getType() {
        return "number";
    }
}

