/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.TagAttributes;
import de.jformchecker.criteria.ValidationResult;
import de.jformchecker.elements.AbstractInput;
import de.jformchecker.request.Request;
import de.jformchecker.validator.Validator;
import java.util.Map;

public class CheckboxInput
extends AbstractInput<CheckboxInput>
implements FormCheckerElement {
    public static CheckboxInput build(String name) {
        CheckboxInput ci = new CheckboxInput();
        ci.name = name;
        return ci;
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        String style = "";
        TagAttributes tagAttributes = new TagAttributes(attributes);
        tagAttributes.add(this.inputAttributes);
        return "<input " + this.buildAllAttributes(tagAttributes) + " type=\"checkbox\" name=\"" + this.name + "\" value=\"" + this.name + "\" " + style + " " + this.getCheckedStatus(this.name) + ">";
    }

    private String getCheckedStatus(String name) {
        if ("true".equals(this.value)) {
            return "checked";
        }
        return "";
    }

    @Override
    public void init(Request request, boolean firstRun, Validator validator) {
        if (firstRun) {
            this.setValue(this.getPreSetValue());
        } else {
            this.value = this.name.equals(request.getParameter(this.getName())) ? "true" : null;
            ValidationResult vr = validator.validate(this);
            if (!vr.isValid()) {
                this.valid = false;
                this.setValidationResult(vr);
            }
            if (this.value == null) {
                this.value = "false";
            }
        }
    }

    public boolean getBoolValue() {
        return "true".equals(this.value);
    }

    @Override
    public String getType() {
        return "checkbox";
    }
}

