/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormValidator;
import de.jformchecker.TagAttributes;
import de.jformchecker.message.MessageSource;
import de.jformchecker.request.SessionGet;
import de.jformchecker.request.SessionSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class FormCheckerForm {
    List<FormCheckerElement> elements = new ArrayList<FormCheckerElement>();
    List<FormValidator> validators = new ArrayList<FormValidator>();
    private Map<String, FormCheckerElement> fastAccess = new LinkedHashMap<String, FormCheckerElement>();
    String submitLabel = "OK";
    private MessageSource messageSource;
    boolean protectedAgainstCSRF = false;
    boolean showSubmitButton = true;
    SessionSet sessionSet;
    SessionGet sessionGet;
    String id = "id";
    Method method = Method.POST;
    private TagAttributes formTagAttributes = new TagAttributes();
    boolean html5Validation = true;

    public String getSubmitLabel() {
        return this.submitLabel;
    }

    public void setSubmitLabel(String submitLabel) {
        this.submitLabel = submitLabel;
    }

    public TagAttributes getFormTagAttributes() {
        return this.formTagAttributes;
    }

    public void setFormTagAttributes(LinkedHashMap<String, String> formTagAttributes) {
        this.formTagAttributes = new TagAttributes(formTagAttributes);
    }

    public Map<String, FormCheckerElement> getElementsAsMap() {
        return this.fastAccess;
    }

    public abstract void init();

    public void disableHtml5Validation() {
        this.html5Validation = false;
    }

    public List<FormValidator> getValidators() {
        return this.validators;
    }

    public FormCheckerForm add(FormCheckerElement elem) {
        this.elements.add(elem);
        this.fastAccess.put(elem.getName(), elem);
        return this;
    }

    public List<FormCheckerElement> getElements() {
        return this.elements;
    }

    public FormCheckerForm addFormValidator(FormValidator formValidator) {
        this.validators.add(formValidator);
        return this;
    }

    public FormCheckerElement getElement(String name) {
        return this.fastAccess.get(name);
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public boolean isProtectedAgainstCSRF() {
        return this.protectedAgainstCSRF;
    }

    public void setProtectedAgainstCSRF(boolean protectedAgainstCSRF) {
        this.protectedAgainstCSRF = protectedAgainstCSRF;
    }

    public SessionGet getSessionGet() {
        return this.sessionGet;
    }

    public void setSessionGet(SessionGet sessionGet) {
        this.sessionGet = sessionGet;
    }

    public SessionSet getSessionSet() {
        return this.sessionSet;
    }

    public void setSessionSet(SessionSet sessionSet) {
        this.sessionSet = sessionSet;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void hideSubmitButton() {
        this.showSubmitButton = false;
    }

    public boolean isShowSubmitButton() {
        return this.showSubmitButton;
    }

    public static enum Method {
        POST,
        GET;

    }
}

