/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker;

import de.jformchecker.Criterion;
import de.jformchecker.FormCheckerConfig;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormCheckerForm;
import de.jformchecker.FormValidator;
import de.jformchecker.GenericFormBuilder;
import de.jformchecker.TagAttributes;
import de.jformchecker.View;
import de.jformchecker.criteria.Criteria;
import de.jformchecker.criteria.MaxLength;
import de.jformchecker.message.MessageSource;
import de.jformchecker.message.MinimalMessageSource;
import de.jformchecker.request.Request;
import de.jformchecker.request.SessionGet;
import de.jformchecker.request.SessionSet;
import de.jformchecker.themes.BasicFormBuilder;
import de.jformchecker.validator.DefaultValidator;
import de.jformchecker.validator.Validator;
import java.util.Map;

public class FormChecker {
    Request req;
    boolean firstRun = true;
    boolean isValid = true;
    FormCheckerForm form = null;
    Validator validator = new DefaultValidator();
    @Deprecated
    String id;
    int defaultMaxLenElements = 1000;
    FormCheckerConfig config;
    String formAction = "#";
    private GenericFormBuilder tempFormBuilder;
    private MessageSource tempProperties;
    public static final String SUBMIT_KEY = "submitted";
    public static final String SUBMIT_VALUE_PREFIX = "FORMCHECKER-";

    @Deprecated
    public FormChecker(String _id, Request request) {
        this.id = _id;
        this.req = request;
    }

    public FormChecker(Request request) {
        this.req = request;
    }

    @Deprecated
    public static FormChecker build(String _id, Request _req, FormCheckerForm form) {
        FormChecker fc = new FormChecker(_id, _req);
        fc.id = _id;
        fc.addForm(form);
        return fc;
    }

    public static FormChecker build(Request _req, FormCheckerForm form) {
        FormChecker fc = new FormChecker(_req);
        fc.addForm(form);
        return fc;
    }

    public FormChecker setProtectAgainstCSRF(SessionGet sessionGet, SessionSet sessionSet) {
        if (this.form == null) {
            throw new IllegalArgumentException("Set the FormcheckerForm BEFORE calling setAgainstCSRF");
        }
        this.form.setProtectedAgainstCSRF(true);
        this.form.setSessionGet(sessionGet);
        this.form.setSessionSet(sessionSet);
        return this;
    }

    public FormChecker setConfig(FormCheckerConfig config) {
        this.config = config;
        return this;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isValidAndNotFirstRun() {
        return this.isValid && !this.firstRun;
    }

    public FormCheckerForm getForm() {
        return this.form;
    }

    private GenericFormBuilder getFormBuilder() {
        return this.config.getFormBuilder();
    }

    public FormChecker setFormBuilder(GenericFormBuilder formBuilder) {
        this.tempFormBuilder = formBuilder;
        return this;
    }

    public FormChecker setProperties(MessageSource properties) {
        this.tempProperties = properties;
        return this;
    }

    public String getValue(String elementName) {
        return this.form.getElement(elementName).getValue();
    }

    public View getView() {
        return new View(this.form, this.getFormBuilder(), this);
    }

    @Deprecated
    public View getViewWithAccessObjects() {
        return new View(this.form, this.getFormBuilder(), this).generateAccessObjects();
    }

    public void setFormAction(String formAction) {
        this.formAction = formAction;
    }

    private void prepareElement(FormCheckerElement element) {
        element.setFormChecker(this);
        boolean maxLenAvail = false;
        for (Criterion criterion : element.getCriteria()) {
            if (!(criterion instanceof MaxLength)) continue;
            maxLenAvail = true;
        }
        if (!maxLenAvail) {
            element.getCriteria().add(Criteria.maxLength(this.defaultMaxLenElements));
        }
    }

    public void addForm(FormCheckerForm form) {
        this.form = form;
        if (this.id != null) {
            form.setId(this.id);
        }
    }

    private String getGenericForm() {
        return this.config.getFormBuilder().generateGenericForm(this.formAction, this.firstRun, this.form, this.req, this.config.properties);
    }

    public String getLabelForElement(FormCheckerElement e, Map<String, String> attribs) {
        return this.config.getFormBuilder().getLabelForElement(e, new TagAttributes(attribs), this.firstRun);
    }

    public FormChecker run() {
        this.setupConfig();
        this.sortTabIndexes();
        this.initForm();
        this.checkIfFirstRun();
        this.processAndValidateElements();
        this.validateCompleteForm();
        return this;
    }

    private void validateCompleteForm() {
        if (!this.firstRun) {
            for (FormValidator formValidator : this.form.getValidators()) {
                if (formValidator.validate(this.form)) continue;
                this.isValid = false;
            }
        }
    }

    private void processAndValidateElements() {
        for (FormCheckerElement elem : this.form.getElements()) {
            elem.init(this.req, this.firstRun, this.validator);
            if (elem.isValid()) continue;
            this.isValid = false;
        }
    }

    private void initForm() {
        this.form.setMessageSource(this.getConfig().getProperties());
        this.form.init();
        for (FormCheckerElement element : this.form.getElements()) {
            this.prepareElement(element);
        }
    }

    private void setupConfig() {
        if (this.config == null) {
            if (this.tempFormBuilder == null) {
                this.tempFormBuilder = new BasicFormBuilder();
            }
            if (this.tempProperties == null) {
                this.tempProperties = new MinimalMessageSource();
            }
            this.config = new FormCheckerConfig(this.tempProperties, this.tempFormBuilder);
        }
    }

    private void sortTabIndexes() {
        int tabIndex = 100;
        for (FormCheckerElement elem : this.form.getElements()) {
            elem.setTabIndex(tabIndex);
            tabIndex = elem.getLastTabIndex();
            ++tabIndex;
        }
    }

    private void checkIfFirstRun() {
        if ((SUBMIT_VALUE_PREFIX + this.form.getId()).equals(this.req.getParameter(SUBMIT_KEY))) {
            this.firstRun = false;
        }
    }

    public String getCompleteForm() {
        return this.getGenericForm();
    }

    public FormCheckerConfig getConfig() {
        return this.config;
    }
}

