/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.security;

import com.coverity.security.Escape;
import de.jformchecker.request.Request;
import de.jformchecker.request.SessionGet;
import de.jformchecker.request.SessionSet;
import de.jformchecker.security.XSRFException;
import java.security.SecureRandom;
import java.util.Base64;

public class XSRFBuilder {
    private final SecureRandom random = new SecureRandom();

    public String buildCSRFTokens(Request req, boolean firstRun, SessionGet sessionGet, SessionSet sessionSet) {
        String xsrfVal;
        String name;
        StringBuilder tags = new StringBuilder();
        String tokenName = "tokenname";
        String tokenVal = "tokenVal";
        if (!firstRun) {
            name = req.getParameter(tokenName);
            xsrfVal = req.getParameter(tokenVal);
            if (xsrfVal == null || !xsrfVal.equals(sessionGet.getAttribute(name))) {
                throw new XSRFException("Security Problem!");
            }
        }
        name = "token-" + Math.random();
        xsrfVal = this.getRandomValue();
        sessionSet.setAttribute(name, xsrfVal);
        tags.append("<input type=\"hidden\" name=\"" + tokenName + "\" value=\"" + Escape.htmlText((String)name) + "\">");
        tags.append("<input type=\"hidden\" name=\"" + tokenVal + "\" value=\"" + Escape.htmlText((String)xsrfVal) + "\">\n");
        return tags.toString();
    }

    private String getRandomValue() {
        byte[] bytes = new byte[32];
        this.random.nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }
}

