/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.TagAttributes;
import de.jformchecker.elements.AbstractInput;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SelectInput
extends AbstractInput<SelectInput>
implements FormCheckerElement {
    List<SelectInputEntry> entries = new ArrayList<SelectInputEntry>();

    public static SelectInput build(String name) {
        SelectInput i = new SelectInput();
        i.name = name;
        return i;
    }

    @Deprecated
    public static SelectInput build(String name, LinkedHashMap<String, String> possibleNames) {
        SelectInput si = SelectInput.build(name);
        si.setPossibleValues(possibleNames);
        return si;
    }

    public static SelectInput build(String name, String[] keys, String[] values) {
        SelectInput si = SelectInput.build(name);
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Key / Values with unequal length");
        }
        ArrayList<SelectInputEntry> entries = new ArrayList<SelectInputEntry>();
        for (int i = 0; i < keys.length; ++i) {
            entries.add(si.generateEntry(keys[i], values[i]));
        }
        si.setEntries(entries);
        return si;
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        TagAttributes tagAttributes = new TagAttributes(attributes);
        tagAttributes.add(this.inputAttributes);
        StringBuilder inputTag = new StringBuilder("<select " + this.buildAllAttributes(tagAttributes) + " name=\"" + this.name + "\" >\n");
        this.entries.forEach(entry -> {
            String sel = "";
            if (this.value != null && this.value.equals(((SelectInputEntry)entry).key)) {
                sel = " SELECTED ";
            }
            inputTag.append("<option value=\"" + ((SelectInputEntry)entry).key + "\"" + sel + ">" + ((SelectInputEntry)entry).value + "</option>\n");
        });
        return inputTag.append("</select>\n").toString();
    }

    @Deprecated
    public SelectInput setPossibleValues(LinkedHashMap<String, String> possibleNames) {
        ArrayList<SelectInputEntry> entries = new ArrayList<SelectInputEntry>();
        possibleNames.forEach((k, v) -> entries.add(this.generateEntry((String)k, (String)v)));
        this.entries = entries;
        return this;
    }

    public SelectInput setEntries(List<SelectInputEntry> entries) {
        this.entries = entries;
        return this;
    }

    @Override
    public void setValue(String value) {
        for (SelectInputEntry entry : this.entries) {
            if (value == null || !value.equals(entry.getKey())) continue;
            this.value = value;
            break;
        }
    }

    @Override
    public String getType() {
        return "select";
    }

    public SelectInputEntry generateEntry(String key, String value) {
        return new SelectInputEntry(key, value);
    }

    public class SelectInputEntry {
        private final String key;
        private final String value;

        public SelectInputEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

