/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.StringUtils;
import de.jformchecker.TagAttributes;
import de.jformchecker.criteria.ValidationResult;
import de.jformchecker.elements.AbstractInput;
import de.jformchecker.elements.SelectInput;
import de.jformchecker.message.CommonSelects;
import de.jformchecker.message.MessageSource;
import de.jformchecker.request.Request;
import de.jformchecker.validator.Validator;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;

public class DateInputSelectCompound
extends AbstractInput<DateInputSelectCompound>
implements FormCheckerElement {
    SelectInput day;
    SelectInput month;
    SelectInput year;
    static String[] months = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
    int yearStart;
    int yearEnd;
    LocalDate internalDate = null;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int YEAR = 3;

    public static DateInputSelectCompound build(String name, int yearStart, int yearEnd) {
        DateInputSelectCompound i = new DateInputSelectCompound();
        i.yearStart = yearStart;
        i.yearEnd = yearEnd;
        i.name = name;
        return i;
    }

    public static DateInputSelectCompound build(String name, YearRange yearRange) {
        return DateInputSelectCompound.build(name, yearRange.start, yearRange.end);
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        TagAttributes tagAttributes = new TagAttributes(attributes);
        tagAttributes.add(this.inputAttributes);
        return this.day.getInputTag(tagAttributes.getAttributes()) + this.month.getInputTag(tagAttributes.getAttributes()) + this.year.getInputTag(tagAttributes.getAttributes());
    }

    @Deprecated
    public DateInputSelectCompound presetValue(LocalDate t) {
        return this.setPresetValue(t);
    }

    public DateInputSelectCompound setPresetValue(LocalDate t) {
        this.internalDate = t;
        return this;
    }

    public String getDatePartTag(int field, Map<String, String> attributes) {
        String inputField = "wrong field desc!";
        switch (field) {
            case 2: {
                inputField = this.day.getInputTag(attributes);
                break;
            }
            case 1: {
                inputField = this.month.getInputTag(attributes);
                break;
            }
            case 3: {
                inputField = this.year.getInputTag(attributes);
            }
        }
        return inputField;
    }

    @Override
    public void init(Request request, boolean firstRun, Validator validator) {
        this.createSelectInputs(this.parent.getConfig().getProperties());
        if (firstRun) {
            if (this.internalDate != null) {
                this.setValue(this.getPreSetValue());
                this.day.setPreSetValue(Integer.toString(this.internalDate.getDayOfMonth()));
                this.month.setPreSetValue(Integer.toString(this.internalDate.getMonthValue()));
                this.year.setPreSetValue(Integer.toString(this.internalDate.getYear()));
            }
        } else {
            this.day.init(request, firstRun, validator);
            this.month.init(request, firstRun, validator);
            this.year.init(request, firstRun, validator);
            if (!this.isRequired() && StringUtils.isEmpty(this.day.getValue()) && StringUtils.isEmpty(this.month.getValue()) && StringUtils.isEmpty(this.year.getValue())) {
                this.valid = true;
            } else {
                String dateVal = this.year.getValue() + "-" + this.month.getValue() + "-" + this.day.getValue();
                this.setValue(dateVal);
                try {
                    this.internalDate = LocalDate.of(Integer.parseInt(this.year.getValue()), Integer.parseInt(this.month.getValue()), Integer.parseInt(this.day.getValue()));
                    this.valid = true;
                    ValidationResult vr = validator.validate(this);
                    this.setValidationResult(vr);
                }
                catch (NumberFormatException | DateTimeException e) {
                    this.valid = false;
                    this.setValidationResult(ValidationResult.fail("jformchecker.wrong_date_format", new Object[0]));
                }
            }
        }
    }

    private void createSelectInputs(MessageSource messageSource) {
        CommonSelects commonSelects = new CommonSelects(messageSource);
        this.day = SelectInput.build("day-" + this.name);
        this.day.setPossibleValues(commonSelects.buildDays());
        this.month = SelectInput.build("month-" + this.name);
        this.month.setPossibleValues(commonSelects.buildMonths());
        this.year = SelectInput.build("year-" + this.name);
        if (this.yearStart < this.yearEnd) {
            int temp = this.yearStart;
            this.yearStart = this.yearEnd;
            this.yearEnd = temp;
        }
        this.year.setPossibleValues(commonSelects.getYears(this.yearStart, this.yearEnd));
    }

    @Override
    public int getLastTabIndex() {
        return this.getTabIndex() + 2;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public LocalDate getDateValue() {
        return this.internalDate;
    }

    public Date getLegacyDateValue() {
        if (this.internalDate == null) {
            return null;
        }
        return Date.from(this.internalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    @Override
    public String getType() {
        return "date-select";
    }

    public static class YearRange {
        int start;
        int end;

        public YearRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public static YearRange aroundNow(int offset) {
            return new YearRange(LocalDate.now().getYear() - offset, LocalDate.now().getYear() + offset);
        }

        public static YearRange past(int numberOfYears) {
            return new YearRange(LocalDate.now().getYear() - numberOfYears, LocalDate.now().getYear());
        }

        public static YearRange currentYear() {
            return new YearRange(LocalDate.now().getYear(), LocalDate.now().getYear());
        }

        public static YearRange future(int numberOfYears) {
            return new YearRange(LocalDate.now().getYear(), LocalDate.now().getYear() + numberOfYears);
        }

        public static YearRange birthday() {
            return new YearRange(LocalDate.now().getYear() - 110, LocalDate.now().getYear());
        }
    }
}

