/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import com.coverity.security.Escape;
import de.jformchecker.AttributeUtils;
import de.jformchecker.Criterion;
import de.jformchecker.FormChecker;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.StringUtils;
import de.jformchecker.TagAttributes;
import de.jformchecker.criteria.MaxLength;
import de.jformchecker.criteria.ValidationResult;
import de.jformchecker.request.Request;
import de.jformchecker.validator.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractInput<T extends FormCheckerElement>
implements FormCheckerElement {
    protected String name;
    protected String value;
    protected String desc;
    protected String preSetValue = "";
    protected int size = -1;
    private List<Criterion> criteria = new ArrayList<Criterion>();
    boolean required;
    private int tabIndex;
    ValidationResult validationResult;
    protected TagAttributes inputAttributes;
    boolean valid = true;
    FormChecker parent;
    String helpText;

    @Override
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Override
    public void setValidationResult(ValidationResult validationResult) {
        this.validationResult = validationResult;
        this.valid = validationResult.isValid();
    }

    protected String buildAllAttributes(Map<String, String> attributes) {
        return this.buildAllAttributes(new TagAttributes(attributes));
    }

    protected String buildAllAttributes(TagAttributes tagAttributes) {
        StringBuilder allAttribs = new StringBuilder();
        allAttribs.append(AttributeUtils.buildAttributes(tagAttributes));
        allAttribs.append(this.getElementId());
        allAttribs.append(this.getTabIndexTag());
        allAttribs.append(this.buildRequiredAttribute());
        allAttribs.append(this.buildSizeAttribute());
        if (!StringUtils.isEmpty(this.helpText)) {
            allAttribs.append(AttributeUtils.buildAttributes(new TagAttributes("aria-describedby", this.parent.getConfig().getFormBuilder().getHelpBlockId(this))));
        }
        return allAttribs.toString();
    }

    public void addCriteria(Criterion c) {
        this.criteria.add(c);
    }

    private Object buildSizeAttribute() {
        if (this.size != -1) {
            return AttributeUtils.buildSingleAttribute("size", Integer.toString(this.size));
        }
        return "";
    }

    protected String buildRequiredAttribute() {
        if (this.required) {
            return " required ";
        }
        return "";
    }

    @Override
    public String getInputTag() {
        return this.getInputTag(new HashMap<String, String>());
    }

    @Override
    public int getLastTabIndex() {
        return this.tabIndex;
    }

    @Override
    public void setFormChecker(FormChecker fc) {
        this.parent = fc;
    }

    @Override
    public String getValueHtmlEncoded() {
        return Escape.html((String)this.value);
    }

    @Override
    public void setInvalid() {
        this.valid = false;
    }

    @Override
    public void init(Request request, boolean firstRun, Validator validator) {
        if (firstRun) {
            this.setValue(this.getPreSetValue());
        } else {
            this.setValue(request.getParameter(this.getName()));
            this.setValidationResult(validator.validate(this));
        }
    }

    @Override
    public T setRequired() {
        this.required = true;
        return (T)this;
    }

    @Override
    public String getLabel() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        return this.parent.getLabelForElement(this, map);
    }

    @Override
    public String getPreSetValue() {
        return this.preSetValue;
    }

    @Override
    public T setPreSetValue(String preSetValue) {
        this.preSetValue = preSetValue;
        this.value = preSetValue;
        return (T)this;
    }

    @Override
    public String getCompleteInput() {
        return this.getLabel() + this.getInputTag();
    }

    public String buildMaxLen() {
        List<Criterion> criteria = this.getCriteria();
        if (criteria != null) {
            for (Criterion criterion : criteria) {
                if (!(criterion instanceof MaxLength)) continue;
                return AttributeUtils.buildSingleAttribute("maxlength", Integer.toString(((MaxLength)criterion).getMaxLength()));
            }
        }
        return "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public T setDescription(String desc) {
        this.desc = desc;
        return (T)this;
    }

    @Override
    public void changeDescription(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public T setCriterias(Criterion ... criteria) {
        this.criteria.addAll(Arrays.asList(criteria));
        return (T)this;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    protected String getElementId() {
        return AttributeUtils.buildSingleAttribute("id", "form-" + this.name);
    }

    @Override
    public int getTabIndex() {
        return this.tabIndex;
    }

    public String getTabIndexTag() {
        return AttributeUtils.buildSingleAttribute("tabindex", Integer.toString(this.getTabIndex()));
    }

    public String getTabIndexTagIncreaseBy(int addition) {
        return AttributeUtils.buildSingleAttribute("tabindex", Integer.toString(this.getTabIndex() + addition));
    }

    @Override
    public T setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
        return (T)this;
    }

    @Override
    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    public T setHelpText(String helpText) {
        this.helpText = helpText;
        return (T)this;
    }

    @Override
    public T setSize(int size) {
        this.size = size;
        return (T)this;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setInputAttributes(TagAttributes inputAttributes) {
        this.inputAttributes = inputAttributes;
    }
}

