/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker;

import de.jformchecker.FormChecker;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormCheckerForm;
import de.jformchecker.GenericFormBuilder;
import de.jformchecker.StringUtils;
import de.jformchecker.TagAttributes;
import de.jformchecker.criteria.ValidationResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class View {
    FormCheckerForm form;
    GenericFormBuilder formBuilder;
    FormChecker fc;
    Map<String, String> elements;
    Map<String, String> inputs;
    Map<String, String> labels;
    Map<String, String> helps;
    Map<String, Boolean> isError;

    View(FormCheckerForm form, GenericFormBuilder formBuilder, FormChecker fc) {
        this.form = form;
        this.formBuilder = formBuilder;
        this.fc = fc;
    }

    public View generateAccessObjects() {
        this.elements = new HashMap<String, String>();
        this.inputs = new HashMap<String, String>();
        this.labels = new HashMap<String, String>();
        this.helps = new HashMap<String, String>();
        this.isError = new HashMap<String, Boolean>();
        this.form.elements.forEach(elem -> this.elements.put(elem.getName(), this.getElement(elem.getName())));
        this.form.elements.forEach(elem -> this.inputs.put(elem.getName(), this.getInput(elem.getName())));
        this.form.elements.forEach(elem -> this.labels.put(elem.getName(), this.getLabel(elem.getName())));
        this.form.elements.forEach(elem -> this.helps.put(elem.getName(), this.getHelp(elem.getName())));
        this.form.elements.forEach(elem -> this.isError.put(elem.getName(), this.isError(elem.getName())));
        return this;
    }

    public String getElement(String name) {
        return this.formBuilder.generateHtmlForElement(this.fc.firstRun, this.fc.config.getProperties(), this.form.getElement(name));
    }

    public List<String> getElementNames() {
        ArrayList<String> elementNames = new ArrayList<String>();
        this.form.elements.forEach(elem -> elementNames.add(elem.getName()));
        return elementNames;
    }

    public String getInput(String name) {
        return this.form.getElement(name).getInputTag();
    }

    public String getInput(String name, Map<String, String> map) {
        return this.form.getElement(name).getInputTag(map);
    }

    public String getType(String name) {
        return this.form.getElement(name).getType();
    }

    public boolean isError(String name) {
        return !this.formBuilder.getErrors(this.form.getElement(name), this.fc.firstRun).isValid();
    }

    public String getError(String name) {
        ValidationResult vr = this.formBuilder.getErrors(this.form.getElement(name), this.fc.firstRun);
        if (!vr.isValid()) {
            return this.fc.config.getProperties().getMessage(vr);
        }
        return "";
    }

    public String getLabel(String name) {
        if (!StringUtils.isEmpty(this.form.getElement(name).getDescription())) {
            return this.formBuilder.getLabelForElement(this.form.getElement(name), new TagAttributes(), this.fc.firstRun);
        }
        return "";
    }

    public String getLabel(String name, Map<String, String> map) {
        return this.formBuilder.getLabelForElement(this.form.getElement(name), new TagAttributes(map), this.fc.firstRun);
    }

    public String getHelp(String name) {
        FormCheckerElement elem = this.form.getElement(name);
        if (!StringUtils.isEmpty(elem.getHelpText())) {
            return elem.getHelpText();
        }
        return "";
    }

    public String getStart() {
        StringBuilder formStart = new StringBuilder(this.formBuilder.generateFormStartTag(this.form, this.fc.formAction));
        formStart.append(this.formBuilder.generateCSRF(this.fc.req, this.fc.firstRun, this.form));
        return formStart.toString();
    }

    public String getEnd() {
        return this.formBuilder.getEndFormTag();
    }

    public String getForm() {
        return this.formBuilder.generateGenericForm(this.fc.formAction, this.fc.firstRun, this.form, this.fc.req, this.fc.config.getProperties());
    }

    public String getSubmit(String label) {
        String t = this.formBuilder.getSubmit(label);
        return t;
    }

    public String getSubmit() {
        String t = this.formBuilder.getSubmit(this.form.getSubmitLabel());
        return t;
    }
}

