/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TagAttributes {
    LinkedHashMap<String, String> attributes;

    public static TagAttributes of(String key, String value) {
        return new TagAttributes(key, value);
    }

    public static TagAttributes of(Map<String, String> attribs) {
        return new TagAttributes(attribs);
    }

    public TagAttributes(Map<String, String> attribs) {
        this.attributes = new LinkedHashMap<String, String>(attribs);
    }

    public TagAttributes(LinkedHashMap<String, String> attribs) {
        this.attributes = attribs;
    }

    public TagAttributes() {
        this(new LinkedHashMap<String, String>());
    }

    public TagAttributes(String key, String value) {
        this();
        this.put(key, value);
    }

    public TagAttributes put(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public String get(String key) {
        return this.attributes.get(key);
    }

    public void addToAttribute(String key, String value) {
        if (!this.attributes.containsKey(key)) {
            this.attributes.put(key, value);
        } else {
            this.attributes.put(key, this.attributes.get(key) + value);
        }
    }

    public Set<String> keySet() {
        return this.attributes.keySet();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void add(TagAttributes formAttributes) {
        if (formAttributes != null) {
            formAttributes.attributes.forEach((key, value) -> this.addToAttribute((String)key, (String)value));
        }
    }

    public void add(LinkedHashMap<String, String> attribs) {
        if (attribs != null) {
            attribs.forEach((key, value) -> this.addToAttribute((String)key, (String)value));
        }
    }
}

