/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker;

import de.jformchecker.AttributeUtils;
import de.jformchecker.FormCheckerConfig;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormCheckerForm;
import de.jformchecker.InputElementStructure;
import de.jformchecker.StringUtils;
import de.jformchecker.TagAttributes;
import de.jformchecker.Wrapper;
import de.jformchecker.criteria.ValidationResult;
import de.jformchecker.elements.FileUploadInput;
import de.jformchecker.message.MessageSource;
import de.jformchecker.request.Request;
import de.jformchecker.security.XSRFBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class GenericFormBuilder {
    String submitClass = "";

    protected abstract String getHelpTag(String var1, FormCheckerElement var2);

    public abstract TagAttributes getLabelAttributes(FormCheckerElement var1);

    public abstract Wrapper getWrapperForInput(FormCheckerElement var1);

    public abstract Wrapper getWrapperForAllFormElements();

    public abstract TagAttributes getFormAttributes();

    public abstract void addAttributesToInputFields(Map<String, String> var1, FormCheckerElement var2);

    public abstract Wrapper getWrapperForElem(FormCheckerElement var1, boolean var2);

    public abstract ValidationResult getErrors(FormCheckerElement var1, boolean var2);

    public abstract Wrapper getWrapperForForm(FormCheckerForm var1, boolean var2);

    @Deprecated
    public final String generateGenericForm(String formAction, boolean firstRun, FormCheckerForm form, Request req, FormCheckerConfig config) {
        return this.generateGenericForm(formAction, firstRun, form, req, config.properties);
    }

    public final String generateGenericForm(String formAction, boolean firstRun, FormCheckerForm form, Request req, MessageSource messages) {
        StringBuilder formHtml = new StringBuilder();
        Wrapper formWrapper = this.getWrapperForForm(form, firstRun);
        formHtml.append(formWrapper.start);
        List<FormCheckerElement> elements = form.getElements();
        formHtml.append(this.generateFormStartTag(form, formAction));
        formHtml.append(this.generateCSRF(req, firstRun, form));
        int lastTabIndex = 0;
        Wrapper allFormElements = this.getWrapperForAllFormElements();
        formHtml.append(allFormElements.start);
        for (FormCheckerElement elem : elements) {
            formHtml.append(this.generateHtmlForElement(firstRun, messages, elem));
            lastTabIndex = elem.getLastTabIndex();
        }
        Wrapper submitWrapper = this.getWrapperForSumit();
        formHtml.append(submitWrapper.start).append(this.getSubmit(lastTabIndex + 1, form.getSubmitLabel())).append(submitWrapper.end);
        formHtml.append(allFormElements.end);
        formHtml.append(this.getEndFormTag());
        formHtml.append(formWrapper.end);
        return formHtml.toString();
    }

    @Deprecated
    String generateHtmlForElement(boolean firstRun, FormCheckerConfig config, FormCheckerElement elem) {
        return this.generateHtmlForElement(firstRun, config.getProperties(), elem);
    }

    String generateHtmlForElement(boolean firstRun, MessageSource messageSource, FormCheckerElement elem) {
        boolean displayLabel;
        InputElementStructure inputStruct = new InputElementStructure();
        ValidationResult vr = this.getErrors(elem, firstRun);
        if (!vr.isValid()) {
            inputStruct.setErrors(this.formatError(messageSource.getMessage(vr)));
        }
        boolean bl = displayLabel = !StringUtils.isEmpty(elem.getDescription());
        if (displayLabel) {
            inputStruct.setLabel(this.getLabelForElement(elem, this.getLabelAttributes(elem), firstRun));
        }
        LinkedHashMap<String, String> attribs = new LinkedHashMap<String, String>();
        this.addAttributesToInputFields(attribs, elem);
        inputStruct.setInput(elem.getInputTag(attribs));
        if (!StringUtils.isEmpty(elem.getHelpText())) {
            inputStruct.setHelp(this.getHelpTag(elem.getHelpText(), elem));
        }
        return this.getCompleteRenderedInput(inputStruct, elem, firstRun);
    }

    String generateCSRF(Request req, boolean firstRun, FormCheckerForm form) {
        if (form.isProtectedAgainstCSRF()) {
            XSRFBuilder csrfBuilder = new XSRFBuilder();
            return csrfBuilder.buildCSRFTokens(req, firstRun, form.sessionGet, form.sessionSet);
        }
        return "";
    }

    public String getHelpBlockId(FormCheckerElement elem) {
        return "helpBlock-" + elem.getName();
    }

    public Wrapper getWrapperForSumit() {
        return Wrapper.empty();
    }

    public abstract String formatError(String var1);

    public String getCompleteRenderedInput(InputElementStructure inputStruct, FormCheckerElement elem, boolean firstRun) {
        StringBuilder elemHtml = new StringBuilder();
        Wrapper elementWrapper = this.getWrapperForElem(elem, firstRun);
        elemHtml.append(elementWrapper.start);
        elemHtml.append(inputStruct.getErrors());
        Wrapper labelWrapper = this.getWrapperForLabel(elem);
        elemHtml.append(labelWrapper.start).append(inputStruct.getLabel()).append(labelWrapper.end);
        Wrapper inputWrapper = this.getWrapperForInput(elem);
        elemHtml.append(inputWrapper.start);
        elemHtml.append(inputStruct.getInput());
        elemHtml.append(inputStruct.getHelp());
        elemHtml.append(inputWrapper.end);
        elemHtml.append(elementWrapper.end);
        return elemHtml.toString();
    }

    public Wrapper getWrapperForLabel(FormCheckerElement elem) {
        return Wrapper.empty();
    }

    public boolean checkMultipart(List<FormCheckerElement> elements) {
        for (FormCheckerElement elem : elements) {
            if (!(elem instanceof FileUploadInput)) continue;
            return true;
        }
        return false;
    }

    public String getEndFormTag() {
        return "</form>\n";
    }

    public String generateFormStartTag(FormCheckerForm form, String formAction) {
        TagAttributes formTagAttributes = this.createFormTagAttributes(form);
        boolean isMultipart = this.checkMultipart(form.getElements());
        StringBuilder formStartTag = new StringBuilder();
        String id = form.getId();
        if (isMultipart) {
            formStartTag.append("<form name=\"" + id + "\" id=\"" + this.buildFormCSSId(id) + "\" action=\"" + formAction + "\" " + AttributeUtils.buildAttributes(formTagAttributes) + "  method=\"" + (Object)((Object)form.getMethod()) + "\" enctype=\"multipart/form-data\">\n");
        } else {
            formStartTag.append("<form name=\"" + id + "\" id=\"" + this.buildFormCSSId(id) + "\" " + AttributeUtils.buildAttributes(formTagAttributes) + " action=\"" + formAction + "\" method=\"" + (Object)((Object)form.getMethod()) + "\" >\n");
        }
        formStartTag.append(this.getSubmittedTag(id));
        return formStartTag.toString();
    }

    public String buildFormCSSId(String id) {
        return "form-" + id;
    }

    TagAttributes createFormTagAttributes(FormCheckerForm form) {
        TagAttributes atribs = new TagAttributes();
        atribs.add(this.getFormAttributes());
        atribs.add(form.getFormTagAttributes());
        if (!form.html5Validation) {
            atribs.addToAttribute("novalidate", "");
        }
        return atribs;
    }

    public String getSubmit(int tabOrder, String submitLabel) {
        return "<input tabindex=\"" + tabOrder + "\" class=\"" + this.submitClass + "\" type=\"submit\" value=\"" + submitLabel + "\">\n";
    }

    public String getSubmit(String submitLabel) {
        return this.getSubmit(0, submitLabel);
    }

    public String getLabelForElement(FormCheckerElement e, TagAttributes attribs, boolean firstRun) {
        return "<label " + AttributeUtils.buildAttributes(attribs) + " for=\"form-" + e.getName() + "\"" + " id=\"" + e.getName() + "-label\">" + e.getDescription() + this.getAddToLabel() + (e.isRequired() ? this.getRequiredChar() : "") + "</label>";
    }

    public String getAddToLabel() {
        return ":";
    }

    public String getRequiredChar() {
        return "*";
    }

    public String getSubmittedTag(String id) {
        return "<input type=\"hidden\" name=\"submitted\" value=\"FORMCHECKER-" + id + "\">\n";
    }
}

