/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.validator;

import de.jformchecker.Criterion;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.criteria.ValidationResult;
import de.jformchecker.validator.Validator;

public class DefaultValidator
implements Validator {
    @Override
    public ValidationResult validate(FormCheckerElement elem) {
        boolean isValid = false;
        String errorMessage = null;
        String value = elem.getValue();
        if (value != null && !"".equals(value)) {
            ErrorMessageAndValidation val = this.allCriteriaSatisfied(elem);
            isValid = val.satisfied;
            errorMessage = val.errorMessage;
        } else if (elem.isRequired()) {
            errorMessage = "required";
            isValid = false;
        } else {
            isValid = true;
        }
        if (!isValid && errorMessage == null) {
            errorMessage = "Invalid or missing value";
        }
        return ValidationResult.of_(isValid, errorMessage, new Object[0]);
    }

    private ErrorMessageAndValidation allCriteriaSatisfied(FormCheckerElement elem) {
        String parsedValue = elem.getValue();
        ErrorMessageAndValidation msgAndValidation = new ErrorMessageAndValidation();
        if (parsedValue == null) {
            msgAndValidation.satisfied = false;
            return msgAndValidation;
        }
        for (Criterion criterion : elem.getCriteria()) {
            ValidationResult vr = criterion.validate(elem);
            if (vr.isValid()) continue;
            msgAndValidation.errorMessage = vr.getMessage();
            msgAndValidation.satisfied = false;
            return msgAndValidation;
        }
        return msgAndValidation;
    }

    private class ErrorMessageAndValidation {
        String errorMessage = null;
        boolean satisfied = true;

        private ErrorMessageAndValidation() {
        }
    }
}

