/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.example.forms;

import de.jformchecker.FormCheckerForm;
import de.jformchecker.criteria.Criteria;
import de.jformchecker.elements.ButtonInput;
import de.jformchecker.elements.CheckboxInput;
import de.jformchecker.elements.DateInput;
import de.jformchecker.elements.DateInputCompound;
import de.jformchecker.elements.HTMLSnippet;
import de.jformchecker.elements.HiddenInput;
import de.jformchecker.elements.LongTextInput;
import de.jformchecker.elements.PasswordInput;
import de.jformchecker.elements.RadioInput;
import de.jformchecker.elements.SelectInput;
import de.jformchecker.elements.TextInput;
import de.jformchecker.example.CustomValidation;
import de.jformchecker.example.PasswordFormValidator;
import java.util.LinkedHashMap;

public class ExampleForm
extends FormCheckerForm {
    @Override
    public void init() {
        this.add(TextInput.build("firstname").setDescription("Your Firstname").setPreSetValue("Peter").setRequired().setCriterias(Criteria.accept("Peter", "Max"), Criteria.maxLength(10)));
        this.add(TextInput.build("lastname").setPlaceholerText("Mustermann").setDescription("Your Lastname").setHelpText("This is an example Helptext for describing this lastname field").setCriterias(Criteria.accept("Pan", "Mustermann")));
        this.add(TextInput.build("middelname").setDescription("Your Middelname").setCriterias(new CustomValidation()));
        this.add(HTMLSnippet.build("headline").setHTML("<h1>Headline</h1>"));
        this.add(HiddenInput.build("hidden").setPreSetValue("something to remember"));
        this.add(ButtonInput.build("btn").setButtonText("Add...").setPreSetValue("add"));
        this.add(DateInput.build("date").setDescription("Birthday"));
        this.add(DateInputCompound.build("date2").setDescription("Mein Tag"));
        this.add(PasswordInput.build("password1").setRequired().setDescription("Password"));
        this.add(PasswordInput.build("password2").setRequired().setDescription("Repeat password"));
        this.add(LongTextInput.build("description").setRequired().setDescription("Your Description"));
        LinkedHashMap<String, String> radioEntries = this.createRadioMap();
        this.add(RadioInput.build("rdio").setPossibleValues(radioEntries).setDescription("Your Choice"));
        LinkedHashMap<String, String> selectEntries = this.createSelectMap();
        this.add(SelectInput.build("select").setPossibleValues(selectEntries).setDescription("Your Selection"));
        this.add(CheckboxInput.build("check").setDescription("I order everything"));
        this.addFormValidator(new PasswordFormValidator());
        this.disableHtml5Validation();
    }

    private LinkedHashMap<String, String> createSelectMap() {
        LinkedHashMap<String, String> selectEntries = new LinkedHashMap<String, String>();
        selectEntries.put("green", "Green");
        selectEntries.put("blue", "Blue");
        selectEntries.put("yellow", "Yellow");
        return selectEntries;
    }

    private LinkedHashMap<String, String> createRadioMap() {
        LinkedHashMap<String, String> radioEntries = new LinkedHashMap<String, String>();
        radioEntries.put("one", "One $");
        radioEntries.put("two", "Two $");
        radioEntries.put("three", "Three $");
        return radioEntries;
    }
}

