/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.criteria.ValidationResult;
import de.jformchecker.elements.AbstractInput;
import de.jformchecker.elements.TextInput;
import de.jformchecker.validator.Validator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class DateInputCompound
extends AbstractInput
implements FormCheckerElement {
    TextInput day;
    TextInput month;
    TextInput year;
    Date internalDate = null;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int YEAR = 3;

    public static DateInputCompound build(String name) {
        DateInputCompound i = new DateInputCompound();
        i.day = TextInput.build("day_" + name);
        i.month = TextInput.build("month_" + name);
        i.year = TextInput.build("year_" + name);
        i.name = name;
        return i;
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        return "<div>" + this.day.getInputTag(attributes) + " " + this.month.getInputTag(attributes) + " " + this.year.getInputTag(attributes) + "</div>";
    }

    public DateInputCompound presetValue(Date t) {
        this.internalDate = t;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(t);
        this.day.setPreSetValue("" + gc.get(5));
        this.month.setPreSetValue("" + (gc.get(2) + 1));
        this.year.setPreSetValue("" + gc.get(1));
        return this;
    }

    public String getDatePartTag(int field, Map<String, String> attributes) {
        String inputField = "wrong field desc!";
        switch (field) {
            case 2: {
                inputField = this.day.getInputTag(attributes);
                break;
            }
            case 1: {
                inputField = this.month.getInputTag(attributes);
                break;
            }
            case 3: {
                inputField = this.year.getInputTag(attributes);
            }
        }
        return inputField;
    }

    @Override
    public void init(HttpServletRequest request, boolean firstRun, Validator validator) {
        if (firstRun) {
            this.setValue(this.getPreSetValue());
        } else {
            this.day.init(request, firstRun, validator);
            this.month.init(request, firstRun, validator);
            this.year.init(request, firstRun, validator);
            if (!this.isRequired() && StringUtils.isEmpty((CharSequence)this.day.getValue()) && StringUtils.isEmpty((CharSequence)this.month.getValue()) && StringUtils.isEmpty((CharSequence)this.year.getValue())) {
                this.valid = true;
            } else {
                String dateVal = this.year.getValue() + "-" + this.month.getValue() + "-" + this.day.getValue();
                this.setValue(dateVal);
                SimpleDateFormat formater = new SimpleDateFormat("yy-MM-dd");
                try {
                    formater.setLenient(false);
                    this.internalDate = formater.parse(dateVal);
                    this.valid = true;
                    ValidationResult vr = validator.validate(this);
                    this.setValidationResult(vr);
                }
                catch (ParseException e) {
                    this.valid = false;
                    this.setValidationResult(ValidationResult.fail("Wrong date format", new Object[0]));
                }
            }
        }
    }

    @Override
    public int getLastTabIndex() {
        return this.getTabIndex() + 2;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public Date getDateValue() {
        return this.internalDate;
    }
}

