/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.Utils;
import de.jformchecker.criteria.ValidationResult;
import de.jformchecker.elements.AbstractInput;
import de.jformchecker.validator.Validator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class DateInput
extends AbstractInput
implements FormCheckerElement {
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int YEAR = 3;
    String dayVal = "";
    String monthVal = "";
    String yearVal = "";
    Date internalDate = null;

    public static DateInput build(String name) {
        DateInput i = new DateInput();
        i.name = name;
        return i;
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        return "<div>" + this.getDatePartTag(2, attributes) + " " + this.getDatePartTag(1, attributes) + " " + this.getDatePartTag(3, attributes) + "</div>";
    }

    public DateInput presetValue(Date t) {
        this.internalDate = t;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(t);
        this.yearVal = "" + gc.get(1);
        this.dayVal = "" + gc.get(5);
        this.monthVal = "" + (gc.get(2) + 1);
        return this;
    }

    public String getDatePartTag(int field, Map<String, String> attributes) {
        String inputField = "wrong field desc!";
        switch (field) {
            case 2: {
                inputField = "<input type=\"text\" " + Utils.buildAttributes(attributes) + this.getTabIndexTag() + " id=\"" + this.name + "_day\" name=\"" + this.name + "_day\" size=\"2\" value=\"" + StringEscapeUtils.escapeHtml4((String)this.dayVal) + "\" maxlength=\"2\" placeholder=\"day\">";
                break;
            }
            case 1: {
                inputField = "<input " + this.getElementId() + Utils.buildAttributes(attributes) + this.getTabIndexTagIncreaseBy(1) + " type=\"text\" id=\"" + this.name + "_month\" size=\"2\" name=\"" + this.name + "_month\"  value=\"" + StringEscapeUtils.escapeHtml4((String)this.monthVal) + "\" maxlength=\"2\" placeholder=\"month\">";
                break;
            }
            case 3: {
                inputField = "<input type=\"text\" " + Utils.buildAttributes(attributes) + this.getTabIndexTagIncreaseBy(2) + " id=\"" + this.name + "_year\" name=\"" + this.name + "_year\" size=\"4\" value=\"" + StringEscapeUtils.escapeHtml4((String)this.yearVal) + "\" maxlength=\"4\" placeholder=\"year\">";
            }
        }
        return inputField;
    }

    @Override
    public void init(HttpServletRequest request, boolean firstRun, Validator validator) {
        if (firstRun) {
            this.setValue(this.getPreSetValue());
        } else {
            this.dayVal = request.getParameter(this.name + "_day");
            this.yearVal = request.getParameter(this.name + "_year");
            this.monthVal = request.getParameter(this.name + "_month");
            if (!this.isRequired() && StringUtils.isEmpty((CharSequence)this.dayVal) && StringUtils.isEmpty((CharSequence)this.yearVal) && StringUtils.isEmpty((CharSequence)this.monthVal)) {
                this.valid = true;
            } else {
                String dateVal = this.yearVal + "-" + this.monthVal + "-" + this.dayVal;
                this.setValue(dateVal);
                SimpleDateFormat formater = new SimpleDateFormat("yy-MM-dd");
                try {
                    formater.setLenient(false);
                    this.internalDate = formater.parse(dateVal);
                    this.valid = true;
                    ValidationResult vr = validator.validate(this);
                    this.setValidationResult(vr);
                }
                catch (ParseException e) {
                    this.valid = false;
                    this.setValidationResult(ValidationResult.fail("Wrong date format", new Object[0]));
                }
            }
        }
    }

    @Override
    public int getLastTabIndex() {
        return this.getTabIndex() + 2;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public Date getDateValue() {
        return this.internalDate;
    }
}

