/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.criteria;

import de.jformchecker.Criterion;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.criteria.ValidationResult;
import java.util.regex.Pattern;

public class Regex
implements Criterion {
    private Pattern pattern;
    private String errorMsg = "The value must match the required format";

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    Regex(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public ValidationResult validate(FormCheckerElement value) {
        boolean isValid = this.pattern.matcher(value.getValue()).find();
        if (!isValid) {
            ValidationResult.fail(this.errorMsg, new Object[0]);
        }
        return ValidationResult.ok();
    }
}

