/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormValidator;
import de.jformchecker.TagAttributes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class FormCheckerForm {
    List<FormCheckerElement> elements = new ArrayList<FormCheckerElement>();
    List<FormValidator> validators = new ArrayList<FormValidator>();
    private Map<String, FormCheckerElement> fastAccess = new LinkedHashMap<String, FormCheckerElement>();
    String submitLabel = "OK";
    private TagAttributes formTagAttributes = new TagAttributes();
    boolean html5Validation = true;

    public FormCheckerForm() {
        this.init();
    }

    public String getSubmitLabel() {
        return this.submitLabel;
    }

    public void setSubmitLabel(String submitLabel) {
        this.submitLabel = submitLabel;
    }

    public TagAttributes getFormTagAttributes() {
        return this.formTagAttributes;
    }

    public void setFormTagAttributes(LinkedHashMap<String, String> formTagAttributes) {
        this.formTagAttributes = new TagAttributes(formTagAttributes);
    }

    public Map<String, FormCheckerElement> getElementsAsMap() {
        return this.fastAccess;
    }

    public abstract void init();

    public void disableHtml5Validation() {
        this.html5Validation = false;
    }

    public List<FormValidator> getValidators() {
        return this.validators;
    }

    public FormCheckerForm add(FormCheckerElement elem) {
        this.elements.add(elem);
        this.fastAccess.put(elem.getName(), elem);
        return this;
    }

    public List<FormCheckerElement> getElements() {
        return this.elements;
    }

    public FormCheckerForm addFormValidator(FormValidator formValidator) {
        this.validators.add(formValidator);
        return this;
    }

    public FormCheckerElement getElement(String name) {
        return this.fastAccess.get(name);
    }
}

