/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.themes;

import de.jformchecker.FormChecker;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.GenericFormBuilder;
import de.jformchecker.TagAttributes;
import de.jformchecker.Wrapper;
import java.util.Map;

public class BasicFormBuilder
extends GenericFormBuilder {
    String divSuccessClass = "has-success";
    String divErrorClass = "has-error";

    @Override
    protected String getHelpTag(String helpText, FormCheckerElement elem) {
        return "<span id=\"" + FormChecker.getHelpBlockId(elem) + "\" class=\"help-block\">" + helpText + "</span>";
    }

    @Override
    public TagAttributes getLabelAttributes(FormCheckerElement elem) {
        TagAttributes attributes = new TagAttributes();
        attributes.put("class", "control-label");
        return attributes;
    }

    @Override
    public Wrapper getWrapperForInput(FormCheckerElement elem) {
        return new Wrapper("<div>", "</div>");
    }

    @Override
    public TagAttributes getFormAttributes() {
        TagAttributes attributes = new TagAttributes();
        return attributes;
    }

    @Override
    public void addAttributesToInputFields(Map<String, String> attribs, FormCheckerElement elem) {
        attribs.put("class", "form-control");
    }

    @Override
    public Wrapper getWrapperForElem(FormCheckerElement elem, boolean firstRun) {
        String state = "";
        if (!firstRun) {
            state = !elem.isValid() ? " " + this.divErrorClass : " " + this.divSuccessClass;
        }
        return new Wrapper("<div class=\"form-group" + state + "\">", "</div>");
    }

    public final void setDivSuccessClass(String divSuccessClass) {
        this.divSuccessClass = divSuccessClass;
    }

    public final void setDivErrorClass(String divErrorClass) {
        this.divErrorClass = divErrorClass;
    }

    @Override
    public String getErrors(FormCheckerElement e, boolean firstRun) {
        if (!firstRun && !e.isValid()) {
            return e.getValidationResult().getMessage();
        }
        return "";
    }

    @Override
    public String formatError(String error) {
        if (error != null && !"".equals(error)) {
            return "Problem: " + error + "!!<br>";
        }
        return "";
    }
}

