/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.example;

import de.jformchecker.FormChecker;
import de.jformchecker.example.BaseController;
import de.jformchecker.example.forms.ExampleFormUpload;
import de.jformchecker.themes.TwoColumnBootstrapFormBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

@WebServlet(value={"/upload"})
@MultipartConfig(location="/tmp", fileSizeThreshold=0x100000, maxFileSize=0x500000L, maxRequestSize=0x1900000L)
public class ControllerFileUpload
extends BaseController {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initRequest(request, response);
        FormChecker formChecker = FormChecker.build("id", request, new ExampleFormUpload()).setFormBuilder(new TwoColumnBootstrapFormBuilder()).run();
        this.putFcInTemplate(response, formChecker, "test.ftl");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initRequest(request, response);
        FormChecker fc = FormChecker.build("id", request, new ExampleFormUpload()).setFormBuilder(new TwoColumnBootstrapFormBuilder()).run();
        this.processResult(fc);
        if (fc.isValidAndNotFirstRun()) {
            this.processRequest(request, response);
        }
        this.putFcInTemplate(response, fc, "test.ftl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        String path = "/Users/jpier/Development/sandbox/uploads";
        Part filePart = request.getPart("upload");
        String fileName = this.getFileName(filePart);
        OutputStream out = null;
        InputStream filecontent = null;
        PrintWriter writer = response.getWriter();
        try {
            out = new FileOutputStream(new File("/Users/jpier/Development/sandbox/uploads" + File.separator + fileName));
            filecontent = filePart.getInputStream();
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = filecontent.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            writer.println("New file " + fileName + " created at " + "/Users/jpier/Development/sandbox/uploads");
            System.err.println("uploaded");
        }
        catch (FileNotFoundException fne) {
            writer.println("You either did not specify a file to upload or are trying to upload a file to a protected or nonexistent location.");
            writer.println("<br/> ERROR: " + fne.getMessage());
            System.err.println("Problems during file upload. Error: {0}" + fne.getMessage());
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (filecontent != null) {
                filecontent.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getFileName(Part part) {
        for (String content : part.getHeader("content-disposition").split(";")) {
            if (!content.trim().startsWith("filename")) continue;
            return content.substring(content.indexOf(61) + 1).trim().replace("\"", "");
        }
        return null;
    }
}

