/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.elements.AbstractInput;
import java.util.LinkedHashMap;
import java.util.Map;

public class SelectInput
extends AbstractInput
implements FormCheckerElement {
    LinkedHashMap<String, String> possibleNames = new LinkedHashMap();

    public static SelectInput build(String name) {
        SelectInput i = new SelectInput();
        i.name = name;
        return i;
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        String inputTag = "<select " + this.buildAllAttributes(attributes) + " name=\"" + this.name + "\" >\n";
        for (String key : this.possibleNames.keySet()) {
            String sel = "";
            if (this.value != null && this.value.equals(key)) {
                sel = " SELECTED ";
            }
            inputTag = inputTag + "<option value=\"" + key + "\"" + sel + ">" + this.possibleNames.get(key) + "</option>\n";
        }
        return inputTag + "</select>\n";
    }

    public SelectInput setPossibleValues(LinkedHashMap<String, String> possibleNames) {
        this.possibleNames = possibleNames;
        return this;
    }

    @Override
    public void setValue(String value) {
        if (this.possibleNames.containsKey(value)) {
            this.value = value;
        }
    }
}

