/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.Utils;
import de.jformchecker.elements.AbstractInput;
import java.util.LinkedHashMap;
import java.util.Map;

public class RadioInput
extends AbstractInput
implements FormCheckerElement {
    LinkedHashMap<String, String> possibleNames = new LinkedHashMap();

    public static RadioInput build(String name) {
        RadioInput i = new RadioInput();
        i.name = name;
        return i;
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        StringBuffer inputTag = new StringBuffer();
        for (String key : this.possibleNames.keySet()) {
            if ("".equals(this.possibleNames.get(key))) continue;
            inputTag.append(this.getInputTag(key, attributes) + " <label for=\"form_radio_" + key + "\" class=\"" + "" + "\" id=\"label_" + this.name + "_" + key + "\">" + this.possibleNames.get(key) + " </label>\n");
        }
        return inputTag.toString();
    }

    public String getInputTag(String curValue, Map<String, String> attributes) {
        return "<input id=\"form_radio_" + curValue + "\" " + Utils.buildAttributes(attributes) + this.getTabIndexTag() + " type=\"radio\" name=\"" + this.name + "\"  value=\"" + curValue + "\" " + this.getCheckedStatus(curValue) + "" + " " + " >\n";
    }

    private String getCheckedStatus(String _name) {
        if (this.value != null && this.value.equals(_name)) {
            return "checked";
        }
        return "";
    }

    @Override
    public int getLastTabIndex() {
        return this.getTabIndex();
    }

    public RadioInput setPossibleValues(LinkedHashMap<String, String> possibleNames) {
        this.possibleNames = possibleNames;
        return this;
    }

    @Override
    public void setValue(String value) {
        if (this.possibleNames.containsKey(value)) {
            this.value = value;
        }
    }
}

