/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.criteria;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.criteria.AbstractCriterion;
import de.jformchecker.criteria.ValidationResult;

public final class Range
extends AbstractCriterion {
    private int min;
    private int max;

    Range(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public ValidationResult validate(FormCheckerElement value) {
        try {
            boolean isValid;
            int intVal = Integer.parseInt(value.getValue());
            boolean bl = isValid = intVal > this.max && intVal < this.min;
            if (!isValid) {
                return ValidationResult.fail("The value must be between %d and %d", this.min, this.max);
            }
            return ValidationResult.ok();
        }
        catch (NumberFormatException e) {
            return ValidationResult.fail("Please enter a number", new Object[0]);
        }
    }
}

