/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker;

import de.jformchecker.FormChecker;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.TagAttributes;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static void fillBean(List<FormCheckerElement> elements, Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (FormCheckerElement elem : elements) {
            String key = elem.getName();
            if (!PropertyUtils.isWriteable((Object)bean, (String)key)) continue;
            PropertyUtils.setSimpleProperty((Object)bean, (String)key, (Object)elem.getValue());
        }
    }

    public static String buildAttributes(Map<String, String> attributes) {
        StringBuilder attrStr = new StringBuilder();
        for (String attribute : attributes.keySet()) {
            attrStr.append(Utils.buildSingleAttribute(attribute, attributes.get(attribute)));
        }
        return attrStr.toString();
    }

    public static String buildSingleAttribute(String key, String value) {
        StringBuilder attrStr = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)value)) {
            attrStr.append(key);
        } else {
            attrStr.append(key).append("=\"").append(value).append("\"");
        }
        attrStr.append(" ");
        return attrStr.toString();
    }

    public static String buildAttributes(TagAttributes attributes) {
        return Utils.buildAttributes(attributes.attributes);
    }

    public static String getDebugOutput(Map<String, FormCheckerElement> elements) {
        int maxLen = 0;
        for (String key : elements.keySet()) {
            if (key.length() <= maxLen) continue;
            maxLen = key.length();
        }
        maxLen += 3;
        StringBuilder debugOutput = new StringBuilder();
        for (String key : elements.keySet()) {
            debugOutput.append(key).append(StringUtils.leftPad((String)":", (int)(maxLen - key.length())));
            debugOutput.append(elements.get(key).getValue()).append("\n");
        }
        return debugOutput.toString();
    }

    public static String getJsonOutput(FormChecker fc) {
        String commaAppend;
        StringBuilder json = new StringBuilder();
        String status = fc.isValidAndNotFirstRun() ? "success" : "fail";
        json.append("{\"status\": \"" + status + "\",");
        json.append("\"data\":");
        if (fc.isValidAndNotFirstRun()) {
            json.append("\"null\",");
        } else {
            json.append("{");
            commaAppend = "";
            for (FormCheckerElement elem : fc.getForm().getElements()) {
                if (elem.isValid()) continue;
                json.append(commaAppend);
                json.append("\"" + elem.getName() + "\":" + "\"" + elem.getValidationResult().getMessage() + "\"");
                commaAppend = ",";
            }
            json.append("},");
        }
        json.append("\"okdata\":");
        json.append("{");
        commaAppend = "";
        for (FormCheckerElement elem : fc.getForm().getElements()) {
            if (!elem.isValid()) continue;
            json.append(commaAppend);
            json.append("\"" + elem.getName() + "\":" + "\"" + "OK" + "\"");
            commaAppend = ",";
        }
        json.append("}");
        json.append("}");
        return json.toString();
    }
}

