/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker;

import de.jformchecker.FormChecker;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormCheckerForm;
import de.jformchecker.InputElementStructure;
import de.jformchecker.TagAttributes;
import de.jformchecker.Utils;
import de.jformchecker.Wrapper;
import de.jformchecker.elements.FileUploadInput;
import de.jformchecker.security.XSRFBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public abstract class GenericFormBuilder {
    String requiredChars = " *";
    String addToLabel = ": ";
    String submitClass = "";

    protected abstract String getHelpTag(String var1, FormCheckerElement var2);

    public abstract TagAttributes getLabelAttributes(FormCheckerElement var1);

    public abstract Wrapper getWrapperForInput(FormCheckerElement var1);

    public abstract TagAttributes getFormAttributes();

    public abstract void addAttributesToInputFields(Map<String, String> var1, FormCheckerElement var2);

    public abstract Wrapper getWrapperForElem(FormCheckerElement var1, boolean var2);

    public abstract String getErrors(FormCheckerElement var1, boolean var2);

    public final String generateGenericForm(String id, String formAction, List<FormCheckerElement> elements, boolean firstRun, FormChecker fc, HttpServletRequest req) {
        StringBuilder formHtml = new StringBuilder();
        TagAttributes formTagAttributes = this.createFormTagAttributes(fc.getForm());
        formHtml.append(this.generateFormStartTag(id, formAction, this.checkMultipart(elements), formTagAttributes));
        if (fc.protectedAgainstCSRF) {
            XSRFBuilder csrfBuilder = new XSRFBuilder();
            formHtml.append(csrfBuilder.buildCSRFTokens(req, firstRun));
        }
        int lastTabIndex = 0;
        for (FormCheckerElement elem : elements) {
            boolean displayLabel;
            InputElementStructure inputStruct = new InputElementStructure();
            String errorMsg = this.getErrors(elem, firstRun);
            if (errorMsg != null) {
                formHtml.append(this.formatError(fc.getConfig().getProperties().getMessage(errorMsg)));
            }
            inputStruct.setErrors(this.getErrors(elem, firstRun));
            boolean bl = displayLabel = !StringUtils.isEmpty((CharSequence)elem.getDescription());
            if (displayLabel) {
                inputStruct.setLabel(this.getLabelForElement(elem, this.getLabelAttributes(elem), firstRun));
            }
            LinkedHashMap<String, String> attribs = new LinkedHashMap<String, String>();
            this.addAttributesToInputFields(attribs, elem);
            inputStruct.setInput(elem.getInputTag(attribs));
            if (!StringUtils.isEmpty((CharSequence)elem.getHelpText())) {
                inputStruct.setHelp(this.getHelpTag(elem.getHelpText(), elem));
            }
            if (displayLabel) {
                // empty if block
            }
            formHtml.append(this.getCompleteRenderedInput(inputStruct, elem, firstRun));
            lastTabIndex = elem.getLastTabIndex();
        }
        formHtml.append(this.getSubmit(lastTabIndex + 1, fc.getForm().getSubmitLabel()));
        formHtml.append(this.getEndFormTag());
        return formHtml.toString();
    }

    public abstract String formatError(String var1);

    public String getCompleteRenderedInput(InputElementStructure inputStruct, FormCheckerElement elem, boolean firstRun) {
        StringBuilder elemHtml = new StringBuilder();
        Wrapper elementWrapper = this.getWrapperForElem(elem, firstRun);
        elemHtml.append(elementWrapper.start);
        elemHtml.append(inputStruct.getErrors());
        elemHtml.append(inputStruct.getLabel());
        Wrapper inputWrapper = this.getWrapperForInput(elem);
        elemHtml.append(inputWrapper.start);
        elemHtml.append(inputStruct.getInput());
        elemHtml.append(inputStruct.getHelp());
        elemHtml.append(inputWrapper.end);
        elemHtml.append(elementWrapper.end);
        return elemHtml.toString();
    }

    private boolean checkMultipart(List<FormCheckerElement> elements) {
        for (FormCheckerElement elem : elements) {
            if (!(elem instanceof FileUploadInput)) continue;
            return true;
        }
        return false;
    }

    public String getEndFormTag() {
        return "</form>\n";
    }

    public String generateFormStartTag(String id, String formAction, boolean isMultipart, TagAttributes formTagAttributes) {
        StringBuilder formStartTag = new StringBuilder();
        if (isMultipart) {
            formStartTag.append("<form name=\"" + id + "\" id=\"form_" + id + "\" action=\"" + formAction + "\" " + Utils.buildAttributes(formTagAttributes) + "  method=\"POST\" enctype=\"multipart/form-data\">\n");
        } else {
            formStartTag.append("<form name=\"" + id + "\" id=\"form_" + id + "\" " + Utils.buildAttributes(formTagAttributes) + " action=\"" + formAction + "\" method=\"GET\" >\n");
        }
        formStartTag.append(this.getSubmittedTag(id));
        return formStartTag.toString();
    }

    private TagAttributes createFormTagAttributes(FormCheckerForm form) {
        TagAttributes atribs = new TagAttributes();
        atribs.add(this.getFormAttributes());
        atribs.add(form.getFormTagAttributes());
        if (!form.html5Validation) {
            atribs.addToAttribute("novalidate", "");
        }
        return atribs;
    }

    public String getSubmit(int tabOrder, String submitLabel) {
        return "<input tabindex=\"" + tabOrder + "\" class=\"" + this.submitClass + "\" type=\"submit\" value=\"" + submitLabel + "\">\n";
    }

    public String getSubmit(String submitLabel) {
        return this.getSubmit(0, submitLabel);
    }

    public String getLabelForElement(FormCheckerElement e, TagAttributes attribs, boolean firstRun) {
        return "<label " + Utils.buildAttributes(attribs) + " for=\"form_" + e.getName() + "\"" + " id=\"" + e.getName() + "_label\">" + e.getDescription() + this.addToLabel + (e.isRequired() ? this.requiredChars : "") + "</label>";
    }

    public String getSubmittedTag(String id) {
        return "<input type=\"hidden\" name=\"submitted\" value=\"FORMCHECKER_" + id + "\">";
    }
}

