/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker;

import de.jformchecker.Criterion;
import de.jformchecker.FormCheckerConfig;
import de.jformchecker.FormCheckerElement;
import de.jformchecker.FormCheckerForm;
import de.jformchecker.FormValidator;
import de.jformchecker.GenericFormBuilder;
import de.jformchecker.TagAttributes;
import de.jformchecker.criteria.Criteria;
import de.jformchecker.criteria.MaxLength;
import de.jformchecker.message.MessageSource;
import de.jformchecker.message.MinimalMessageSource;
import de.jformchecker.themes.BasicFormBuilder;
import de.jformchecker.validator.DefaultValidator;
import de.jformchecker.validator.Validator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class FormChecker {
    HttpServletRequest req;
    boolean firstRun = true;
    boolean isValid = true;
    FormCheckerForm form = null;
    Validator validator = new DefaultValidator();
    boolean protectedAgainstCSRF = false;
    String completeForm;
    int defaultMaxLenElements = 1000;
    FormCheckerConfig config;
    String id;
    private String formAction = "#";
    private GenericFormBuilder tempFormBuilder;
    private MessageSource tempProperties;
    public static final String SUBMIT_KEY = "submitted";
    public static final String SUBMIT_VALUE_PREFIX = "FORMCHECKER_";

    public FormChecker(String _id, HttpServletRequest _req) {
        this.id = _id;
        this.req = _req;
    }

    public static FormChecker build(String _id, HttpServletRequest _req, FormCheckerForm form) {
        FormChecker fc = new FormChecker(_id, _req);
        fc.addForm(form);
        return fc;
    }

    public FormChecker setProtectAgainstCSRF() {
        this.protectedAgainstCSRF = true;
        return this;
    }

    public FormChecker setConfig(FormCheckerConfig config) {
        this.config = config;
        return this;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isValidAndNotFirstRun() {
        return this.isValid && !this.firstRun;
    }

    public FormCheckerForm getForm() {
        return this.form;
    }

    public GenericFormBuilder getFormBuilder() {
        return this.config.getFormBuilder();
    }

    public FormChecker setFormBuilder(GenericFormBuilder formBuilder) {
        this.tempFormBuilder = formBuilder;
        return this;
    }

    public FormChecker setProperties(MessageSource properties) {
        this.tempProperties = properties;
        return this;
    }

    public static String getHelpBlockId(FormCheckerElement elem) {
        return "helpBlock_" + elem.getName();
    }

    public String getValue(String elementName) {
        return this.form.getElement(elementName).getValue();
    }

    public String getSubmitTag() {
        return this.config.getFormBuilder().getSubmittedTag(this.id);
    }

    public String getLabelTag(String elementName) {
        return this.config.getFormBuilder().getLabelForElement(this.form.getElement(elementName), new TagAttributes(), this.firstRun);
    }

    public String getLabelTag(String elementName, Map<String, String> map) {
        return this.config.getFormBuilder().getLabelForElement(this.form.getElement(elementName), new TagAttributes(map), this.firstRun);
    }

    public void setFormAction(String formAction) {
        this.formAction = formAction;
    }

    private void prepareElement(FormCheckerElement element) {
        element.setFormChecker(this);
        boolean maxLenAvail = false;
        for (Criterion criterion : element.getCriteria()) {
            if (!(criterion instanceof MaxLength)) continue;
            maxLenAvail = true;
        }
        if (!maxLenAvail) {
            element.getCriteria().add(Criteria.maxLength(this.defaultMaxLenElements));
        }
    }

    public void addForm(FormCheckerForm form) {
        for (FormCheckerElement element : form.getElements()) {
            this.prepareElement(element);
        }
        this.form = form;
    }

    private String getGenericForm() {
        return this.config.getFormBuilder().generateGenericForm(this.id, this.formAction, this.form.elements, this.firstRun, this, this.req);
    }

    public String getLabelForElement(FormCheckerElement e, Map<String, String> attribs) {
        return this.config.getFormBuilder().getLabelForElement(e, new TagAttributes(attribs), this.firstRun);
    }

    public FormChecker run() {
        this.setupConfig();
        this.sortTabIndexes();
        this.checkIfFirstRun();
        for (FormCheckerElement elem : this.form.getElements()) {
            elem.init(this.req, this.firstRun, this.validator);
            if (elem.isValid()) continue;
            this.isValid = false;
        }
        if (this.form != null) {
            for (FormValidator formValidator : this.form.getValidators()) {
                formValidator.validate(this.form);
            }
        }
        this.completeForm = this.getGenericForm();
        return this;
    }

    private void setupConfig() {
        if (this.config == null) {
            if (this.tempFormBuilder == null) {
                this.tempFormBuilder = new BasicFormBuilder();
            }
            if (this.tempProperties == null) {
                this.tempProperties = new MinimalMessageSource();
            }
            this.config = new FormCheckerConfig(this.tempProperties, this.tempFormBuilder);
        }
    }

    private void sortTabIndexes() {
        int tabIndex = 100;
        for (FormCheckerElement elem : this.form.getElements()) {
            elem.setTabIndex(tabIndex);
            tabIndex = elem.getLastTabIndex();
            ++tabIndex;
        }
    }

    private void checkIfFirstRun() {
        if ((SUBMIT_VALUE_PREFIX + this.id).equals(this.req.getParameter(SUBMIT_KEY))) {
            this.firstRun = false;
        }
    }

    public String getCompleteForm() {
        return this.completeForm;
    }

    public FormCheckerConfig getConfig() {
        return this.config;
    }
}

