/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.example;

import de.jformchecker.FormChecker;
import de.jformchecker.Utils;
import de.jformchecker.elements.DateInput;
import de.jformchecker.elements.TextInput;
import de.jformchecker.example.ExampleBean;
import de.jformchecker.example.forms.ExampleForm;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value={"/TestAdd"})
public class TestDynamicElement
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    Configuration cfg;

    private void init(ServletContext context) {
        this.cfg = new Configuration(Configuration.VERSION_2_3_22);
        this.cfg.setServletContextForTemplateLoading((Object)context, "/");
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setTemplateUpdateDelayMilliseconds(4L);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initRequest(request, response);
        ExampleForm form = new ExampleForm();
        if (request.getSession().getAttribute("add") != null) {
            form.add(TextInput.build("text").setDescription("Additional"));
        }
        FormChecker fc = FormChecker.build("id", request, form).setProtectAgainstCSRF().run();
        this.processResult(fc, request);
        try {
            HashMap<String, FormChecker> root = new HashMap<String, FormChecker>();
            root.put("fc", fc);
            Template temp = this.cfg.getTemplate("test.ftl");
            temp.process(root, (Writer)response.getWriter());
        }
        catch (TemplateException e1) {
            e1.printStackTrace();
        }
    }

    private void processResult(FormChecker fc, HttpServletRequest request) {
        if (fc.isValidAndNotFirstRun()) {
            ExampleBean bean = new ExampleBean();
            try {
                Utils.fillBean(fc.getForm().getElements(), bean);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            System.out.println("bean:" + bean);
            System.out.println(((DateInput)fc.getForm().getElement("date")).getDateValue());
            System.out.println("--------------");
            System.out.println(Utils.getDebugOutput(fc.getForm().getElementsAsMap()));
            if ("add".equals(fc.getValue("btn"))) {
                System.out.println("add this!!!");
                request.getSession().setAttribute("add", (Object)"add");
            }
        }
    }

    private void initRequest(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/html; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        if (this.cfg == null) {
            this.init(request.getServletContext());
        }
    }
}

