/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.example;

import de.jformchecker.FormChecker;
import de.jformchecker.Utils;
import de.jformchecker.example.ExampleBean;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseController
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    Configuration cfg;

    private void initFreemarkerConfig(ServletContext context) {
        this.cfg = new Configuration(Configuration.VERSION_2_3_22);
        this.cfg.setServletContextForTemplateLoading((Object)context, "/");
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setTemplateUpdateDelayMilliseconds(4L);
    }

    public final void putFcInTemplate(HttpServletResponse response, FormChecker fc, String templateName) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        try {
            HashMap<String, FormChecker> root = new HashMap<String, FormChecker>();
            root.put("fc", fc);
            Template temp = this.cfg.getTemplate(templateName);
            temp.process(root, (Writer)response.getWriter());
        }
        catch (TemplateException e1) {
            e1.printStackTrace();
        }
    }

    protected void processResult(FormChecker fc) {
        if (fc.isValid()) {
            ExampleBean bean = new ExampleBean();
            try {
                Utils.fillBean(fc.getForm().getElements(), bean);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            System.out.println("bean:" + bean);
            System.out.println("--------------");
            System.out.println(Utils.getDebugOutput(fc.getForm().getElementsAsMap()));
        }
    }

    protected void initRequest(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/html; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        if (this.cfg == null) {
            this.initFreemarkerConfig(request.getServletContext());
        }
    }
}

