/*
 * Decompiled with CFR 0.152.
 */
package de.jformchecker.elements;

import de.jformchecker.FormCheckerElement;
import de.jformchecker.elements.AbstractInput;
import de.jformchecker.validator.Validator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class CheckboxInput
extends AbstractInput
implements FormCheckerElement {
    public static CheckboxInput build(String name) {
        CheckboxInput ci = new CheckboxInput();
        ci.name = name;
        return ci;
    }

    @Override
    public String getInputTag(Map<String, String> attributes) {
        String style = "";
        return "<input " + this.buildAllAttributes(attributes) + " type=\"checkbox\" name=\"" + this.name + "\" id=\"" + this.name + "\" value=\"" + this.name + "\" " + style + " " + this.getCheckedStatus(this.name) + ">";
    }

    private String getCheckedStatus(String name) {
        if ("true".equals(this.value)) {
            return "checked";
        }
        return "";
    }

    @Override
    public void init(HttpServletRequest request, boolean firstRun, Validator validator) {
        if (firstRun) {
            this.setValue(this.getPreSetValue());
        } else {
            this.value = this.name.equals(request.getParameter(this.getName())) ? "true" : "false";
            String errMsg = validator.validate(this);
            if (errMsg != null) {
                this.valid = false;
                this.setErrorMessage(errMsg);
            }
        }
    }

    public boolean getBoolValue() {
        return "true".equals(this.valid);
    }
}

